/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssessmentTargetRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, CreateAssessmentTargetRequest> {
    private static final SdkField<String> ASSESSMENT_TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssessmentTargetRequest.getter(CreateAssessmentTargetRequest::assessmentTargetName)).setter(CreateAssessmentTargetRequest.setter(Builder::assessmentTargetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetName").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateAssessmentTargetRequest.getter(CreateAssessmentTargetRequest::resourceGroupArn)).setter(CreateAssessmentTargetRequest.setter(Builder::resourceGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_NAME_FIELD, RESOURCE_GROUP_ARN_FIELD));
    private final String assessmentTargetName;
    private final String resourceGroupArn;

    private CreateAssessmentTargetRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetName = builder.assessmentTargetName;
        this.resourceGroupArn = builder.resourceGroupArn;
    }

    public String assessmentTargetName() {
        return this.assessmentTargetName;
    }

    public String resourceGroupArn() {
        return this.resourceGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTargetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentTargetRequest)) {
            return false;
        }
        CreateAssessmentTargetRequest other = (CreateAssessmentTargetRequest)((Object)obj);
        return Objects.equals(this.assessmentTargetName(), other.assessmentTargetName()) && Objects.equals(this.resourceGroupArn(), other.resourceGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateAssessmentTargetRequest").add("AssessmentTargetName", (Object)this.assessmentTargetName()).add("ResourceGroupArn", (Object)this.resourceGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTargetName": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargetName()));
            }
            case "resourceGroupArn": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentTargetRequest, T> g) {
        return obj -> g.apply((CreateAssessmentTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private String assessmentTargetName;
        private String resourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentTargetRequest model) {
            super(model);
            this.assessmentTargetName(model.assessmentTargetName);
            this.resourceGroupArn(model.resourceGroupArn);
        }

        public final String getAssessmentTargetName() {
            return this.assessmentTargetName;
        }

        @Override
        public final Builder assessmentTargetName(String assessmentTargetName) {
            this.assessmentTargetName = assessmentTargetName;
            return this;
        }

        public final void setAssessmentTargetName(String assessmentTargetName) {
            this.assessmentTargetName = assessmentTargetName;
        }

        public final String getResourceGroupArn() {
            return this.resourceGroupArn;
        }

        @Override
        public final Builder resourceGroupArn(String resourceGroupArn) {
            this.resourceGroupArn = resourceGroupArn;
            return this;
        }

        public final void setResourceGroupArn(String resourceGroupArn) {
            this.resourceGroupArn = resourceGroupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentTargetRequest build() {
            return new CreateAssessmentTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssessmentTargetRequest> {
        public Builder assessmentTargetName(String var1);

        public Builder resourceGroupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

