/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceGroupsRequest extends InspectorRequest implements
        ToCopyableBuilder<DescribeResourceGroupsRequest.Builder, DescribeResourceGroupsRequest> {
    private static final SdkField<List<String>> RESOURCE_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeResourceGroupsRequest::resourceGroupArns))
            .setter(setter(Builder::resourceGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_ARNS_FIELD));

    private final List<String> resourceGroupArns;

    private DescribeResourceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupArns = builder.resourceGroupArns;
    }

    /**
     * Returns true if the ResourceGroupArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceGroupArns() {
        return resourceGroupArns != null && !(resourceGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN that specifies the resource group that you want to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceGroupArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARN that specifies the resource group that you want to describe.
     */
    public List<String> resourceGroupArns() {
        return resourceGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupsRequest)) {
            return false;
        }
        DescribeResourceGroupsRequest other = (DescribeResourceGroupsRequest) obj;
        return Objects.equals(resourceGroupArns(), other.resourceGroupArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeResourceGroupsRequest").add("ResourceGroupArns", resourceGroupArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceGroupArns":
            return Optional.ofNullable(clazz.cast(resourceGroupArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceGroupsRequest, T> g) {
        return obj -> g.apply((DescribeResourceGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeResourceGroupsRequest> {
        /**
         * <p>
         * The ARN that specifies the resource group that you want to describe.
         * </p>
         * 
         * @param resourceGroupArns
         *        The ARN that specifies the resource group that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupArns(Collection<String> resourceGroupArns);

        /**
         * <p>
         * The ARN that specifies the resource group that you want to describe.
         * </p>
         * 
         * @param resourceGroupArns
         *        The ARN that specifies the resource group that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupArns(String... resourceGroupArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private List<String> resourceGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceGroupsRequest model) {
            super(model);
            resourceGroupArns(model.resourceGroupArns);
        }

        public final Collection<String> getResourceGroupArns() {
            return resourceGroupArns;
        }

        @Override
        public final Builder resourceGroupArns(Collection<String> resourceGroupArns) {
            this.resourceGroupArns = BatchDescribeArnListCopier.copy(resourceGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupArns(String... resourceGroupArns) {
            resourceGroupArns(Arrays.asList(resourceGroupArns));
            return this;
        }

        public final void setResourceGroupArns(Collection<String> resourceGroupArns) {
            this.resourceGroupArns = BatchDescribeArnListCopier.copy(resourceGroupArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeResourceGroupsRequest build() {
            return new DescribeResourceGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
