/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRulesPackagesResponse extends InspectorResponse implements
        ToCopyableBuilder<DescribeRulesPackagesResponse.Builder, DescribeRulesPackagesResponse> {
    private static final SdkField<List<RulesPackage>> RULES_PACKAGES_FIELD = SdkField
            .<List<RulesPackage>> builder(MarshallingType.LIST)
            .getter(getter(DescribeRulesPackagesResponse::rulesPackages))
            .setter(setter(Builder::rulesPackages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RulesPackage> builder(MarshallingType.SDK_POJO)
                                            .constructor(RulesPackage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField
            .<Map<String, FailedItemDetails>> builder(MarshallingType.MAP)
            .getter(getter(DescribeRulesPackagesResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailedItemDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedItemDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_PACKAGES_FIELD,
            FAILED_ITEMS_FIELD));

    private final List<RulesPackage> rulesPackages;

    private final Map<String, FailedItemDetails> failedItems;

    private DescribeRulesPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.rulesPackages = builder.rulesPackages;
        this.failedItems = builder.failedItems;
    }

    /**
     * Returns true if the RulesPackages property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRulesPackages() {
        return rulesPackages != null && !(rulesPackages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the rules package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRulesPackages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the rules package.
     */
    public List<RulesPackage> rulesPackages() {
        return rulesPackages;
    }

    /**
     * Returns true if the FailedItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailedItems() {
        return failedItems != null && !(failedItems instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Rules package details that cannot be described. An error code is provided for each failed item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Rules package details that cannot be described. An error code is provided for each failed item.
     */
    public Map<String, FailedItemDetails> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rulesPackages());
        hashCode = 31 * hashCode + Objects.hashCode(failedItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesPackagesResponse)) {
            return false;
        }
        DescribeRulesPackagesResponse other = (DescribeRulesPackagesResponse) obj;
        return Objects.equals(rulesPackages(), other.rulesPackages()) && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRulesPackagesResponse").add("RulesPackages", rulesPackages())
                .add("FailedItems", failedItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rulesPackages":
            return Optional.ofNullable(clazz.cast(rulesPackages()));
        case "failedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRulesPackagesResponse, T> g) {
        return obj -> g.apply((DescribeRulesPackagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRulesPackagesResponse> {
        /**
         * <p>
         * Information about the rules package.
         * </p>
         * 
         * @param rulesPackages
         *        Information about the rules package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackages(Collection<RulesPackage> rulesPackages);

        /**
         * <p>
         * Information about the rules package.
         * </p>
         * 
         * @param rulesPackages
         *        Information about the rules package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackages(RulesPackage... rulesPackages);

        /**
         * <p>
         * Information about the rules package.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RulesPackage>.Builder} avoiding the need to
         * create one manually via {@link List<RulesPackage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RulesPackage>.Builder#build()} is called immediately and its
         * result is passed to {@link #rulesPackages(List<RulesPackage>)}.
         * 
         * @param rulesPackages
         *        a consumer that will call methods on {@link List<RulesPackage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rulesPackages(List<RulesPackage>)
         */
        Builder rulesPackages(Consumer<RulesPackage.Builder>... rulesPackages);

        /**
         * <p>
         * Rules package details that cannot be described. An error code is provided for each failed item.
         * </p>
         * 
         * @param failedItems
         *        Rules package details that cannot be described. An error code is provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Map<String, FailedItemDetails> failedItems);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<RulesPackage> rulesPackages = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesPackagesResponse model) {
            super(model);
            rulesPackages(model.rulesPackages);
            failedItems(model.failedItems);
        }

        public final Collection<RulesPackage.Builder> getRulesPackages() {
            return rulesPackages != null ? rulesPackages.stream().map(RulesPackage::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder rulesPackages(Collection<RulesPackage> rulesPackages) {
            this.rulesPackages = RulesPackageListCopier.copy(rulesPackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackages(RulesPackage... rulesPackages) {
            rulesPackages(Arrays.asList(rulesPackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackages(Consumer<RulesPackage.Builder>... rulesPackages) {
            rulesPackages(Stream.of(rulesPackages).map(c -> RulesPackage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRulesPackages(Collection<RulesPackage.BuilderImpl> rulesPackages) {
            this.rulesPackages = RulesPackageListCopier.copyFromBuilder(rulesPackages);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            return failedItems != null ? CollectionUtils.mapValues(failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeRulesPackagesResponse build() {
            return new DescribeRulesPackagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
