/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about what is excluded from an assessment run given the current state of the assessment
 * template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExclusionPreview implements SdkPojo, Serializable,
        ToCopyableBuilder<ExclusionPreview.Builder, ExclusionPreview> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExclusionPreview::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExclusionPreview::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExclusionPreview::recommendation)).setter(setter(Builder::recommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<List<Scope>> SCOPES_FIELD = SdkField
            .<List<Scope>> builder(MarshallingType.LIST)
            .getter(getter(ExclusionPreview::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Scope> builder(MarshallingType.SDK_POJO)
                                            .constructor(Scope::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .getter(getter(ExclusionPreview::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            DESCRIPTION_FIELD, RECOMMENDATION_FIELD, SCOPES_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String description;

    private final String recommendation;

    private final List<Scope> scopes;

    private final List<Attribute> attributes;

    private ExclusionPreview(BuilderImpl builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.recommendation = builder.recommendation;
        this.scopes = builder.scopes;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The name of the exclusion preview.
     * </p>
     * 
     * @return The name of the exclusion preview.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The description of the exclusion preview.
     * </p>
     * 
     * @return The description of the exclusion preview.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The recommendation for the exclusion preview.
     * </p>
     * 
     * @return The recommendation for the exclusion preview.
     */
    public String recommendation() {
        return recommendation;
    }

    /**
     * Returns true if the Scopes property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS resources for which the exclusion preview pertains.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScopes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS resources for which the exclusion preview pertains.
     */
    public List<Scope> scopes() {
        return scopes;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The system-defined attributes for the exclusion preview.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The system-defined attributes for the exclusion preview.
     */
    public List<Attribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(scopes());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExclusionPreview)) {
            return false;
        }
        ExclusionPreview other = (ExclusionPreview) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(recommendation(), other.recommendation()) && Objects.equals(scopes(), other.scopes())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExclusionPreview").add("Title", title()).add("Description", description())
                .add("Recommendation", recommendation()).add("Scopes", scopes()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExclusionPreview, T> g) {
        return obj -> g.apply((ExclusionPreview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExclusionPreview> {
        /**
         * <p>
         * The name of the exclusion preview.
         * </p>
         * 
         * @param title
         *        The name of the exclusion preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the exclusion preview.
         * </p>
         * 
         * @param description
         *        The description of the exclusion preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The recommendation for the exclusion preview.
         * </p>
         * 
         * @param recommendation
         *        The recommendation for the exclusion preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(String recommendation);

        /**
         * <p>
         * The AWS resources for which the exclusion preview pertains.
         * </p>
         * 
         * @param scopes
         *        The AWS resources for which the exclusion preview pertains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<Scope> scopes);

        /**
         * <p>
         * The AWS resources for which the exclusion preview pertains.
         * </p>
         * 
         * @param scopes
         *        The AWS resources for which the exclusion preview pertains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Scope... scopes);

        /**
         * <p>
         * The AWS resources for which the exclusion preview pertains.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Scope>.Builder} avoiding the need to create
         * one manually via {@link List<Scope>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Scope>.Builder#build()} is called immediately and its result
         * is passed to {@link #scopes(List<Scope>)}.
         * 
         * @param scopes
         *        a consumer that will call methods on {@link List<Scope>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopes(List<Scope>)
         */
        Builder scopes(Consumer<Scope.Builder>... scopes);

        /**
         * <p>
         * The system-defined attributes for the exclusion preview.
         * </p>
         * 
         * @param attributes
         *        The system-defined attributes for the exclusion preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * The system-defined attributes for the exclusion preview.
         * </p>
         * 
         * @param attributes
         *        The system-defined attributes for the exclusion preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * The system-defined attributes for the exclusion preview.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String description;

        private String recommendation;

        private List<Scope> scopes = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExclusionPreview model) {
            title(model.title);
            description(model.description);
            recommendation(model.recommendation);
            scopes(model.scopes);
            attributes(model.attributes);
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRecommendation() {
            return recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        public final Collection<Scope.Builder> getScopes() {
            return scopes != null ? scopes.stream().map(Scope::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scopes(Collection<Scope> scopes) {
            this.scopes = ScopeListCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Scope... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(Consumer<Scope.Builder>... scopes) {
            scopes(Stream.of(scopes).map(c -> Scope.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScopes(Collection<Scope.BuilderImpl> scopes) {
            this.scopes = ScopeListCopier.copyFromBuilder(scopes);
        }

        public final Collection<Attribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public ExclusionPreview build() {
            return new ExclusionPreview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
