/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssessmentRunResponse extends InspectorResponse implements
        ToCopyableBuilder<StartAssessmentRunResponse.Builder, StartAssessmentRunResponse> {
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartAssessmentRunResponse::assessmentRunArn)).setter(setter(Builder::assessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARN_FIELD));

    private final String assessmentRunArn;

    private StartAssessmentRunResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArn = builder.assessmentRunArn;
    }

    /**
     * <p>
     * The ARN of the assessment run that has been started.
     * </p>
     * 
     * @return The ARN of the assessment run that has been started.
     */
    public String assessmentRunArn() {
        return assessmentRunArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentRunResponse)) {
            return false;
        }
        StartAssessmentRunResponse other = (StartAssessmentRunResponse) obj;
        return Objects.equals(assessmentRunArn(), other.assessmentRunArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartAssessmentRunResponse").add("AssessmentRunArn", assessmentRunArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRunArn":
            return Optional.ofNullable(clazz.cast(assessmentRunArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentRunResponse, T> g) {
        return obj -> g.apply((StartAssessmentRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartAssessmentRunResponse> {
        /**
         * <p>
         * The ARN of the assessment run that has been started.
         * </p>
         * 
         * @param assessmentRunArn
         *        The ARN of the assessment run that has been started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArn(String assessmentRunArn);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private String assessmentRunArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentRunResponse model) {
            super(model);
            assessmentRunArn(model.assessmentRunArn);
        }

        public final String getAssessmentRunArn() {
            return assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        @Override
        public StartAssessmentRunResponse build() {
            return new StartAssessmentRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
