/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used as one of the elements of the <a>AssessmentRun</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentRunNotification implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentRunNotification.Builder, AssessmentRunNotification> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AssessmentRunNotification::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssessmentRunNotification::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssessmentRunNotification::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Boolean> ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AssessmentRunNotification::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssessmentRunNotification::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()).build();

    private static final SdkField<String> SNS_PUBLISH_STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssessmentRunNotification::snsPublishStatusCodeAsString))
            .setter(setter(Builder::snsPublishStatusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsPublishStatusCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, EVENT_FIELD,
            MESSAGE_FIELD, ERROR_FIELD, SNS_TOPIC_ARN_FIELD, SNS_PUBLISH_STATUS_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant date;

    private final String event;

    private final String message;

    private final Boolean error;

    private final String snsTopicArn;

    private final String snsPublishStatusCode;

    private AssessmentRunNotification(BuilderImpl builder) {
        this.date = builder.date;
        this.event = builder.event;
        this.message = builder.message;
        this.error = builder.error;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsPublishStatusCode = builder.snsPublishStatusCode;
    }

    /**
     * <p>
     * The date of the notification.
     * </p>
     * 
     * @return The date of the notification.
     */
    public Instant date() {
        return date;
    }

    /**
     * <p>
     * The event for which a notification is sent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link InspectorEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event for which a notification is sent.
     * @see InspectorEvent
     */
    public InspectorEvent event() {
        return InspectorEvent.fromValue(event);
    }

    /**
     * <p>
     * The event for which a notification is sent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link InspectorEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event for which a notification is sent.
     * @see InspectorEvent
     */
    public String eventAsString() {
        return event;
    }

    /**
     * <p>
     * The message included in the notification.
     * </p>
     * 
     * @return The message included in the notification.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The Boolean value that specifies whether the notification represents an error.
     * </p>
     * 
     * @return The Boolean value that specifies whether the notification represents an error.
     */
    public Boolean error() {
        return error;
    }

    /**
     * <p>
     * The SNS topic to which the SNS notification is sent.
     * </p>
     * 
     * @return The SNS topic to which the SNS notification is sent.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The status code of the SNS notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snsPublishStatusCode} will return {@link AssessmentRunNotificationSnsStatusCode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #snsPublishStatusCodeAsString}.
     * </p>
     * 
     * @return The status code of the SNS notification.
     * @see AssessmentRunNotificationSnsStatusCode
     */
    public AssessmentRunNotificationSnsStatusCode snsPublishStatusCode() {
        return AssessmentRunNotificationSnsStatusCode.fromValue(snsPublishStatusCode);
    }

    /**
     * <p>
     * The status code of the SNS notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snsPublishStatusCode} will return {@link AssessmentRunNotificationSnsStatusCode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #snsPublishStatusCodeAsString}.
     * </p>
     * 
     * @return The status code of the SNS notification.
     * @see AssessmentRunNotificationSnsStatusCode
     */
    public String snsPublishStatusCodeAsString() {
        return snsPublishStatusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsPublishStatusCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunNotification)) {
            return false;
        }
        AssessmentRunNotification other = (AssessmentRunNotification) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(eventAsString(), other.eventAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(error(), other.error())
                && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(snsPublishStatusCodeAsString(), other.snsPublishStatusCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssessmentRunNotification").add("Date", date()).add("Event", eventAsString())
                .add("Message", message()).add("Error", error()).add("SnsTopicArn", snsTopicArn())
                .add("SnsPublishStatusCode", snsPublishStatusCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        case "event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "snsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "snsPublishStatusCode":
            return Optional.ofNullable(clazz.cast(snsPublishStatusCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunNotification, T> g) {
        return obj -> g.apply((AssessmentRunNotification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentRunNotification> {
        /**
         * <p>
         * The date of the notification.
         * </p>
         * 
         * @param date
         *        The date of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The event for which a notification is sent.
         * </p>
         * 
         * @param event
         *        The event for which a notification is sent.
         * @see InspectorEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectorEvent
         */
        Builder event(String event);

        /**
         * <p>
         * The event for which a notification is sent.
         * </p>
         * 
         * @param event
         *        The event for which a notification is sent.
         * @see InspectorEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectorEvent
         */
        Builder event(InspectorEvent event);

        /**
         * <p>
         * The message included in the notification.
         * </p>
         * 
         * @param message
         *        The message included in the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The Boolean value that specifies whether the notification represents an error.
         * </p>
         * 
         * @param error
         *        The Boolean value that specifies whether the notification represents an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(Boolean error);

        /**
         * <p>
         * The SNS topic to which the SNS notification is sent.
         * </p>
         * 
         * @param snsTopicArn
         *        The SNS topic to which the SNS notification is sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The status code of the SNS notification.
         * </p>
         * 
         * @param snsPublishStatusCode
         *        The status code of the SNS notification.
         * @see AssessmentRunNotificationSnsStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentRunNotificationSnsStatusCode
         */
        Builder snsPublishStatusCode(String snsPublishStatusCode);

        /**
         * <p>
         * The status code of the SNS notification.
         * </p>
         * 
         * @param snsPublishStatusCode
         *        The status code of the SNS notification.
         * @see AssessmentRunNotificationSnsStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentRunNotificationSnsStatusCode
         */
        Builder snsPublishStatusCode(AssessmentRunNotificationSnsStatusCode snsPublishStatusCode);
    }

    static final class BuilderImpl implements Builder {
        private Instant date;

        private String event;

        private String message;

        private Boolean error;

        private String snsTopicArn;

        private String snsPublishStatusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunNotification model) {
            date(model.date);
            event(model.event);
            message(model.message);
            error(model.error);
            snsTopicArn(model.snsTopicArn);
            snsPublishStatusCode(model.snsPublishStatusCode);
        }

        public final Instant getDate() {
            return date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final String getEventAsString() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(InspectorEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Boolean getError() {
            return error;
        }

        @Override
        public final Builder error(Boolean error) {
            this.error = error;
            return this;
        }

        public final void setError(Boolean error) {
            this.error = error;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSnsPublishStatusCodeAsString() {
            return snsPublishStatusCode;
        }

        @Override
        public final Builder snsPublishStatusCode(String snsPublishStatusCode) {
            this.snsPublishStatusCode = snsPublishStatusCode;
            return this;
        }

        @Override
        public final Builder snsPublishStatusCode(AssessmentRunNotificationSnsStatusCode snsPublishStatusCode) {
            this.snsPublishStatusCode(snsPublishStatusCode == null ? null : snsPublishStatusCode.toString());
            return this;
        }

        public final void setSnsPublishStatusCode(String snsPublishStatusCode) {
            this.snsPublishStatusCode = snsPublishStatusCode;
        }

        @Override
        public AssessmentRunNotification build() {
            return new AssessmentRunNotification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
