/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an Amazon Inspector finding. This data type is used as the response element in the
 * <a>DescribeFindings</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Finding implements SdkPojo, Serializable, ToCopyableBuilder<Finding.Builder, Finding> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Integer> SCHEMA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Finding::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<InspectorServiceAttributes> SERVICE_ATTRIBUTES_FIELD = SdkField
            .<InspectorServiceAttributes> builder(MarshallingType.SDK_POJO).getter(getter(Finding::serviceAttributes))
            .setter(setter(Builder::serviceAttributes)).constructor(InspectorServiceAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAttributes").build()).build();

    private static final SdkField<String> ASSET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::assetTypeAsString)).setter(setter(Builder::assetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetType").build()).build();

    private static final SdkField<AssetAttributes> ASSET_ATTRIBUTES_FIELD = SdkField
            .<AssetAttributes> builder(MarshallingType.SDK_POJO).getter(getter(Finding::assetAttributes))
            .setter(setter(Builder::assetAttributes)).constructor(AssetAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetAttributes").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::recommendation)).setter(setter(Builder::recommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Finding::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<Double> NUMERIC_SEVERITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Finding::numericSeverity)).setter(setter(Builder::numericSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numericSeverity").build()).build();

    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Finding::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()).build();

    private static final SdkField<Boolean> INDICATOR_OF_COMPROMISE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Finding::indicatorOfCompromise)).setter(setter(Builder::indicatorOfCompromise))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indicatorOfCompromise").build())
            .build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .getter(getter(Finding::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .getter(getter(Finding::userAttributes))
            .setter(setter(Builder::userAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Finding::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Finding::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            SCHEMA_VERSION_FIELD, SERVICE_FIELD, SERVICE_ATTRIBUTES_FIELD, ASSET_TYPE_FIELD, ASSET_ATTRIBUTES_FIELD, ID_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, RECOMMENDATION_FIELD, SEVERITY_FIELD, NUMERIC_SEVERITY_FIELD, CONFIDENCE_FIELD,
            INDICATOR_OF_COMPROMISE_FIELD, ATTRIBUTES_FIELD, USER_ATTRIBUTES_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Integer schemaVersion;

    private final String service;

    private final InspectorServiceAttributes serviceAttributes;

    private final String assetType;

    private final AssetAttributes assetAttributes;

    private final String id;

    private final String title;

    private final String description;

    private final String recommendation;

    private final String severity;

    private final Double numericSeverity;

    private final Integer confidence;

    private final Boolean indicatorOfCompromise;

    private final List<Attribute> attributes;

    private final List<Attribute> userAttributes;

    private final Instant createdAt;

    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.arn = builder.arn;
        this.schemaVersion = builder.schemaVersion;
        this.service = builder.service;
        this.serviceAttributes = builder.serviceAttributes;
        this.assetType = builder.assetType;
        this.assetAttributes = builder.assetAttributes;
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.recommendation = builder.recommendation;
        this.severity = builder.severity;
        this.numericSeverity = builder.numericSeverity;
        this.confidence = builder.confidence;
        this.indicatorOfCompromise = builder.indicatorOfCompromise;
        this.attributes = builder.attributes;
        this.userAttributes = builder.userAttributes;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ARN that specifies the finding.
     * </p>
     * 
     * @return The ARN that specifies the finding.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The schema version of this data type.
     * </p>
     * 
     * @return The schema version of this data type.
     */
    public Integer schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The data element is set to "Inspector".
     * </p>
     * 
     * @return The data element is set to "Inspector".
     */
    public String service() {
        return service;
    }

    /**
     * <p>
     * This data type is used in the <a>Finding</a> data type.
     * </p>
     * 
     * @return This data type is used in the <a>Finding</a> data type.
     */
    public InspectorServiceAttributes serviceAttributes() {
        return serviceAttributes;
    }

    /**
     * <p>
     * The type of the host from which the finding is generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetType} will
     * return {@link AssetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assetTypeAsString}.
     * </p>
     * 
     * @return The type of the host from which the finding is generated.
     * @see AssetType
     */
    public AssetType assetType() {
        return AssetType.fromValue(assetType);
    }

    /**
     * <p>
     * The type of the host from which the finding is generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assetType} will
     * return {@link AssetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #assetTypeAsString}.
     * </p>
     * 
     * @return The type of the host from which the finding is generated.
     * @see AssetType
     */
    public String assetTypeAsString() {
        return assetType;
    }

    /**
     * <p>
     * A collection of attributes of the host from which the finding is generated.
     * </p>
     * 
     * @return A collection of attributes of the host from which the finding is generated.
     */
    public AssetAttributes assetAttributes() {
        return assetAttributes;
    }

    /**
     * <p>
     * The ID of the finding.
     * </p>
     * 
     * @return The ID of the finding.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the finding.
     * </p>
     * 
     * @return The name of the finding.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The description of the finding.
     * </p>
     * 
     * @return The description of the finding.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The recommendation for the finding.
     * </p>
     * 
     * @return The recommendation for the finding.
     */
    public String recommendation() {
        return recommendation;
    }

    /**
     * <p>
     * The finding severity. Values can be set to High, Medium, Low, and Informational.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The finding severity. Values can be set to High, Medium, Low, and Informational.
     * @see Severity
     */
    public Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * The finding severity. Values can be set to High, Medium, Low, and Informational.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The finding severity. Values can be set to High, Medium, Low, and Informational.
     * @see Severity
     */
    public String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The numeric value of the finding severity.
     * </p>
     * 
     * @return The numeric value of the finding severity.
     */
    public Double numericSeverity() {
        return numericSeverity;
    }

    /**
     * <p>
     * This data element is currently not used.
     * </p>
     * 
     * @return This data element is currently not used.
     */
    public Integer confidence() {
        return confidence;
    }

    /**
     * <p>
     * This data element is currently not used.
     * </p>
     * 
     * @return This data element is currently not used.
     */
    public Boolean indicatorOfCompromise() {
        return indicatorOfCompromise;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The system-defined attributes for the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The system-defined attributes for the finding.
     */
    public List<Attribute> attributes() {
        return attributes;
    }

    /**
     * Returns true if the UserAttributes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserAttributes() {
        return userAttributes != null && !(userAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user-defined attributes that are assigned to the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The user-defined attributes that are assigned to the finding.
     */
    public List<Attribute> userAttributes() {
        return userAttributes;
    }

    /**
     * <p>
     * The time when the finding was generated.
     * </p>
     * 
     * @return The time when the finding was generated.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when <a>AddAttributesToFindings</a> is called.
     * </p>
     * 
     * @return The time when <a>AddAttributesToFindings</a> is called.
     */
    public Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(assetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(assetAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numericSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(indicatorOfCompromise());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(schemaVersion(), other.schemaVersion())
                && Objects.equals(service(), other.service()) && Objects.equals(serviceAttributes(), other.serviceAttributes())
                && Objects.equals(assetTypeAsString(), other.assetTypeAsString())
                && Objects.equals(assetAttributes(), other.assetAttributes()) && Objects.equals(id(), other.id())
                && Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(recommendation(), other.recommendation())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(numericSeverity(), other.numericSeverity()) && Objects.equals(confidence(), other.confidence())
                && Objects.equals(indicatorOfCompromise(), other.indicatorOfCompromise())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(userAttributes(), other.userAttributes())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Finding").add("Arn", arn()).add("SchemaVersion", schemaVersion()).add("Service", service())
                .add("ServiceAttributes", serviceAttributes()).add("AssetType", assetTypeAsString())
                .add("AssetAttributes", assetAttributes()).add("Id", id()).add("Title", title())
                .add("Description", description()).add("Recommendation", recommendation()).add("Severity", severityAsString())
                .add("NumericSeverity", numericSeverity()).add("Confidence", confidence())
                .add("IndicatorOfCompromise", indicatorOfCompromise()).add("Attributes", attributes())
                .add("UserAttributes", userAttributes()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "serviceAttributes":
            return Optional.ofNullable(clazz.cast(serviceAttributes()));
        case "assetType":
            return Optional.ofNullable(clazz.cast(assetTypeAsString()));
        case "assetAttributes":
            return Optional.ofNullable(clazz.cast(assetAttributes()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "numericSeverity":
            return Optional.ofNullable(clazz.cast(numericSeverity()));
        case "confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "indicatorOfCompromise":
            return Optional.ofNullable(clazz.cast(indicatorOfCompromise()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "userAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Finding> {
        /**
         * <p>
         * The ARN that specifies the finding.
         * </p>
         * 
         * @param arn
         *        The ARN that specifies the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The schema version of this data type.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of this data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(Integer schemaVersion);

        /**
         * <p>
         * The data element is set to "Inspector".
         * </p>
         * 
         * @param service
         *        The data element is set to "Inspector".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * This data type is used in the <a>Finding</a> data type.
         * </p>
         * 
         * @param serviceAttributes
         *        This data type is used in the <a>Finding</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAttributes(InspectorServiceAttributes serviceAttributes);

        /**
         * <p>
         * This data type is used in the <a>Finding</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link InspectorServiceAttributes.Builder} avoiding the
         * need to create one manually via {@link InspectorServiceAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link InspectorServiceAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceAttributes(InspectorServiceAttributes)}.
         * 
         * @param serviceAttributes
         *        a consumer that will call methods on {@link InspectorServiceAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAttributes(InspectorServiceAttributes)
         */
        default Builder serviceAttributes(Consumer<InspectorServiceAttributes.Builder> serviceAttributes) {
            return serviceAttributes(InspectorServiceAttributes.builder().applyMutation(serviceAttributes).build());
        }

        /**
         * <p>
         * The type of the host from which the finding is generated.
         * </p>
         * 
         * @param assetType
         *        The type of the host from which the finding is generated.
         * @see AssetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetType
         */
        Builder assetType(String assetType);

        /**
         * <p>
         * The type of the host from which the finding is generated.
         * </p>
         * 
         * @param assetType
         *        The type of the host from which the finding is generated.
         * @see AssetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetType
         */
        Builder assetType(AssetType assetType);

        /**
         * <p>
         * A collection of attributes of the host from which the finding is generated.
         * </p>
         * 
         * @param assetAttributes
         *        A collection of attributes of the host from which the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetAttributes(AssetAttributes assetAttributes);

        /**
         * <p>
         * A collection of attributes of the host from which the finding is generated.
         * </p>
         * This is a convenience that creates an instance of the {@link AssetAttributes.Builder} avoiding the need to
         * create one manually via {@link AssetAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #assetAttributes(AssetAttributes)}.
         * 
         * @param assetAttributes
         *        a consumer that will call methods on {@link AssetAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetAttributes(AssetAttributes)
         */
        default Builder assetAttributes(Consumer<AssetAttributes.Builder> assetAttributes) {
            return assetAttributes(AssetAttributes.builder().applyMutation(assetAttributes).build());
        }

        /**
         * <p>
         * The ID of the finding.
         * </p>
         * 
         * @param id
         *        The ID of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the finding.
         * </p>
         * 
         * @param title
         *        The name of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the finding.
         * </p>
         * 
         * @param description
         *        The description of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The recommendation for the finding.
         * </p>
         * 
         * @param recommendation
         *        The recommendation for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(String recommendation);

        /**
         * <p>
         * The finding severity. Values can be set to High, Medium, Low, and Informational.
         * </p>
         * 
         * @param severity
         *        The finding severity. Values can be set to High, Medium, Low, and Informational.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The finding severity. Values can be set to High, Medium, Low, and Informational.
         * </p>
         * 
         * @param severity
         *        The finding severity. Values can be set to High, Medium, Low, and Informational.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * The numeric value of the finding severity.
         * </p>
         * 
         * @param numericSeverity
         *        The numeric value of the finding severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericSeverity(Double numericSeverity);

        /**
         * <p>
         * This data element is currently not used.
         * </p>
         * 
         * @param confidence
         *        This data element is currently not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Integer confidence);

        /**
         * <p>
         * This data element is currently not used.
         * </p>
         * 
         * @param indicatorOfCompromise
         *        This data element is currently not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indicatorOfCompromise(Boolean indicatorOfCompromise);

        /**
         * <p>
         * The system-defined attributes for the finding.
         * </p>
         * 
         * @param attributes
         *        The system-defined attributes for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * The system-defined attributes for the finding.
         * </p>
         * 
         * @param attributes
         *        The system-defined attributes for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * The system-defined attributes for the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);

        /**
         * <p>
         * The user-defined attributes that are assigned to the finding.
         * </p>
         * 
         * @param userAttributes
         *        The user-defined attributes that are assigned to the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Collection<Attribute> userAttributes);

        /**
         * <p>
         * The user-defined attributes that are assigned to the finding.
         * </p>
         * 
         * @param userAttributes
         *        The user-defined attributes that are assigned to the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Attribute... userAttributes);

        /**
         * <p>
         * The user-defined attributes that are assigned to the finding.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #userAttributes(List<Attribute>)}.
         * 
         * @param userAttributes
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributes(List<Attribute>)
         */
        Builder userAttributes(Consumer<Attribute.Builder>... userAttributes);

        /**
         * <p>
         * The time when the finding was generated.
         * </p>
         * 
         * @param createdAt
         *        The time when the finding was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when <a>AddAttributesToFindings</a> is called.
         * </p>
         * 
         * @param updatedAt
         *        The time when <a>AddAttributesToFindings</a> is called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Integer schemaVersion;

        private String service;

        private InspectorServiceAttributes serviceAttributes;

        private String assetType;

        private AssetAttributes assetAttributes;

        private String id;

        private String title;

        private String description;

        private String recommendation;

        private String severity;

        private Double numericSeverity;

        private Integer confidence;

        private Boolean indicatorOfCompromise;

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> userAttributes = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            arn(model.arn);
            schemaVersion(model.schemaVersion);
            service(model.service);
            serviceAttributes(model.serviceAttributes);
            assetType(model.assetType);
            assetAttributes(model.assetAttributes);
            id(model.id);
            title(model.title);
            description(model.description);
            recommendation(model.recommendation);
            severity(model.severity);
            numericSeverity(model.numericSeverity);
            confidence(model.confidence);
            indicatorOfCompromise(model.indicatorOfCompromise);
            attributes(model.attributes);
            userAttributes(model.userAttributes);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final InspectorServiceAttributes.Builder getServiceAttributes() {
            return serviceAttributes != null ? serviceAttributes.toBuilder() : null;
        }

        @Override
        public final Builder serviceAttributes(InspectorServiceAttributes serviceAttributes) {
            this.serviceAttributes = serviceAttributes;
            return this;
        }

        public final void setServiceAttributes(InspectorServiceAttributes.BuilderImpl serviceAttributes) {
            this.serviceAttributes = serviceAttributes != null ? serviceAttributes.build() : null;
        }

        public final String getAssetTypeAsString() {
            return assetType;
        }

        @Override
        public final Builder assetType(String assetType) {
            this.assetType = assetType;
            return this;
        }

        @Override
        public final Builder assetType(AssetType assetType) {
            this.assetType(assetType == null ? null : assetType.toString());
            return this;
        }

        public final void setAssetType(String assetType) {
            this.assetType = assetType;
        }

        public final AssetAttributes.Builder getAssetAttributes() {
            return assetAttributes != null ? assetAttributes.toBuilder() : null;
        }

        @Override
        public final Builder assetAttributes(AssetAttributes assetAttributes) {
            this.assetAttributes = assetAttributes;
            return this;
        }

        public final void setAssetAttributes(AssetAttributes.BuilderImpl assetAttributes) {
            this.assetAttributes = assetAttributes != null ? assetAttributes.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRecommendation() {
            return recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        public final String getSeverityAsString() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Double getNumericSeverity() {
            return numericSeverity;
        }

        @Override
        public final Builder numericSeverity(Double numericSeverity) {
            this.numericSeverity = numericSeverity;
            return this;
        }

        public final void setNumericSeverity(Double numericSeverity) {
            this.numericSeverity = numericSeverity;
        }

        public final Integer getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        public final Boolean getIndicatorOfCompromise() {
            return indicatorOfCompromise;
        }

        @Override
        public final Builder indicatorOfCompromise(Boolean indicatorOfCompromise) {
            this.indicatorOfCompromise = indicatorOfCompromise;
            return this;
        }

        public final void setIndicatorOfCompromise(Boolean indicatorOfCompromise) {
            this.indicatorOfCompromise = indicatorOfCompromise;
        }

        public final Collection<Attribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributeListCopier.copyFromBuilder(attributes);
        }

        public final Collection<Attribute.Builder> getUserAttributes() {
            return userAttributes != null ? userAttributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<Attribute> userAttributes) {
            this.userAttributes = UserAttributeListCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Attribute... userAttributes) {
            userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<Attribute.Builder>... userAttributes) {
            userAttributes(Stream.of(userAttributes).map(c -> Attribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<Attribute.BuilderImpl> userAttributes) {
            this.userAttributes = UserAttributeListCopier.copyFromBuilder(userAttributes);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public Finding build() {
            return new Finding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
