/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.BatchDescribeArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceGroupsRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, DescribeResourceGroupsRequest> {
    private static final SdkField<List<String>> RESOURCE_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeResourceGroupsRequest.getter(DescribeResourceGroupsRequest::resourceGroupArns)).setter(DescribeResourceGroupsRequest.setter(Builder::resourceGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_ARNS_FIELD));
    private final List<String> resourceGroupArns;

    private DescribeResourceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupArns = builder.resourceGroupArns;
    }

    public boolean hasResourceGroupArns() {
        return this.resourceGroupArns != null && !(this.resourceGroupArns instanceof SdkAutoConstructList);
    }

    public List<String> resourceGroupArns() {
        return this.resourceGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceGroupsRequest)) {
            return false;
        }
        DescribeResourceGroupsRequest other = (DescribeResourceGroupsRequest)((Object)obj);
        return Objects.equals(this.resourceGroupArns(), other.resourceGroupArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeResourceGroupsRequest").add("ResourceGroupArns", this.resourceGroupArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceGroupArns": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceGroupsRequest, T> g) {
        return obj -> g.apply((DescribeResourceGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> resourceGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceGroupsRequest model) {
            super(model);
            this.resourceGroupArns(model.resourceGroupArns);
        }

        public final Collection<String> getResourceGroupArns() {
            return this.resourceGroupArns;
        }

        @Override
        public final Builder resourceGroupArns(Collection<String> resourceGroupArns) {
            this.resourceGroupArns = BatchDescribeArnListCopier.copy(resourceGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupArns(String ... resourceGroupArns) {
            this.resourceGroupArns(Arrays.asList(resourceGroupArns));
            return this;
        }

        public final void setResourceGroupArns(Collection<String> resourceGroupArns) {
            this.resourceGroupArns = BatchDescribeArnListCopier.copy(resourceGroupArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeResourceGroupsRequest build() {
            return new DescribeResourceGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceGroupsRequest> {
        public Builder resourceGroupArns(Collection<String> var1);

        public Builder resourceGroupArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

