/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.TelemetryMetadata;
import software.amazon.awssdk.services.inspector.model.TelemetryMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTelemetryMetadataResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, GetTelemetryMetadataResponse> {
    private static final SdkField<List<TelemetryMetadata>> TELEMETRY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetTelemetryMetadataResponse.getter(GetTelemetryMetadataResponse::telemetryMetadata)).setter(GetTelemetryMetadataResponse.setter(Builder::telemetryMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telemetryMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TelemetryMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_METADATA_FIELD));
    private final List<TelemetryMetadata> telemetryMetadata;

    private GetTelemetryMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.telemetryMetadata = builder.telemetryMetadata;
    }

    public boolean hasTelemetryMetadata() {
        return this.telemetryMetadata != null && !(this.telemetryMetadata instanceof SdkAutoConstructList);
    }

    public List<TelemetryMetadata> telemetryMetadata() {
        return this.telemetryMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTelemetryMetadataResponse)) {
            return false;
        }
        GetTelemetryMetadataResponse other = (GetTelemetryMetadataResponse)((Object)obj);
        return Objects.equals(this.telemetryMetadata(), other.telemetryMetadata());
    }

    public String toString() {
        return ToString.builder((String)"GetTelemetryMetadataResponse").add("TelemetryMetadata", this.telemetryMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "telemetryMetadata": {
                return Optional.ofNullable(clazz.cast(this.telemetryMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTelemetryMetadataResponse, T> g) {
        return obj -> g.apply((GetTelemetryMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<TelemetryMetadata> telemetryMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTelemetryMetadataResponse model) {
            super(model);
            this.telemetryMetadata(model.telemetryMetadata);
        }

        public final Collection<TelemetryMetadata.Builder> getTelemetryMetadata() {
            return this.telemetryMetadata != null ? (Collection)this.telemetryMetadata.stream().map(TelemetryMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder telemetryMetadata(Collection<TelemetryMetadata> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copy(telemetryMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(TelemetryMetadata ... telemetryMetadata) {
            this.telemetryMetadata(Arrays.asList(telemetryMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder> ... telemetryMetadata) {
            this.telemetryMetadata(Stream.of(telemetryMetadata).map(c -> (TelemetryMetadata)((TelemetryMetadata.Builder)TelemetryMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTelemetryMetadata(Collection<TelemetryMetadata.BuilderImpl> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copyFromBuilder(telemetryMetadata);
        }

        @Override
        public GetTelemetryMetadataResponse build() {
            return new GetTelemetryMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTelemetryMetadataResponse> {
        public Builder telemetryMetadata(Collection<TelemetryMetadata> var1);

        public Builder telemetryMetadata(TelemetryMetadata ... var1);

        public Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder> ... var1);
    }
}

