/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.RulesPackage;
import software.amazon.awssdk.services.inspector.model.RulesPackageListCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRulesPackagesResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeRulesPackagesResponse> {
    private static final SdkField<List<RulesPackage>> RULES_PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rulesPackages").getter(DescribeRulesPackagesResponse.getter(DescribeRulesPackagesResponse::rulesPackages)).setter(DescribeRulesPackagesResponse.setter(Builder::rulesPackages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RulesPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("failedItems").getter(DescribeRulesPackagesResponse.getter(DescribeRulesPackagesResponse::failedItems)).setter(DescribeRulesPackagesResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_PACKAGES_FIELD, FAILED_ITEMS_FIELD));
    private final List<RulesPackage> rulesPackages;
    private final Map<String, FailedItemDetails> failedItems;

    private DescribeRulesPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.rulesPackages = builder.rulesPackages;
        this.failedItems = builder.failedItems;
    }

    public boolean hasRulesPackages() {
        return this.rulesPackages != null && !(this.rulesPackages instanceof SdkAutoConstructList);
    }

    public List<RulesPackage> rulesPackages() {
        return this.rulesPackages;
    }

    public boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructMap);
    }

    public Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesPackages() ? this.rulesPackages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesPackagesResponse)) {
            return false;
        }
        DescribeRulesPackagesResponse other = (DescribeRulesPackagesResponse)((Object)obj);
        return this.hasRulesPackages() == other.hasRulesPackages() && Objects.equals(this.rulesPackages(), other.rulesPackages()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRulesPackagesResponse").add("RulesPackages", this.hasRulesPackages() ? this.rulesPackages() : null).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rulesPackages": {
                return Optional.ofNullable(clazz.cast(this.rulesPackages()));
            }
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRulesPackagesResponse, T> g) {
        return obj -> g.apply((DescribeRulesPackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<RulesPackage> rulesPackages = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesPackagesResponse model) {
            super(model);
            this.rulesPackages(model.rulesPackages);
            this.failedItems(model.failedItems);
        }

        public final Collection<RulesPackage.Builder> getRulesPackages() {
            if (this.rulesPackages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesPackages != null ? (Collection)this.rulesPackages.stream().map(RulesPackage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rulesPackages(Collection<RulesPackage> rulesPackages) {
            this.rulesPackages = RulesPackageListCopier.copy(rulesPackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackages(RulesPackage ... rulesPackages) {
            this.rulesPackages(Arrays.asList(rulesPackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackages(Consumer<RulesPackage.Builder> ... rulesPackages) {
            this.rulesPackages(Stream.of(rulesPackages).map(c -> (RulesPackage)((RulesPackage.Builder)RulesPackage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRulesPackages(Collection<RulesPackage.BuilderImpl> rulesPackages) {
            this.rulesPackages = RulesPackageListCopier.copyFromBuilder(rulesPackages);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            if (this.failedItems instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.failedItems != null ? CollectionUtils.mapValues(this.failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeRulesPackagesResponse build() {
            return new DescribeRulesPackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRulesPackagesResponse> {
        public Builder rulesPackages(Collection<RulesPackage> var1);

        public Builder rulesPackages(RulesPackage ... var1);

        public Builder rulesPackages(Consumer<RulesPackage.Builder> ... var1);

        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

