/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.ReportFileFormat;
import software.amazon.awssdk.services.inspector.model.ReportType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssessmentReportRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, GetAssessmentReportRequest> {
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentRunArn").getter(GetAssessmentReportRequest.getter(GetAssessmentReportRequest::assessmentRunArn)).setter(GetAssessmentReportRequest.setter(Builder::assessmentRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()}).build();
    private static final SdkField<String> REPORT_FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportFileFormat").getter(GetAssessmentReportRequest.getter(GetAssessmentReportRequest::reportFileFormatAsString)).setter(GetAssessmentReportRequest.setter(Builder::reportFileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFileFormat").build()}).build();
    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportType").getter(GetAssessmentReportRequest.getter(GetAssessmentReportRequest::reportTypeAsString)).setter(GetAssessmentReportRequest.setter(Builder::reportType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARN_FIELD, REPORT_FILE_FORMAT_FIELD, REPORT_TYPE_FIELD));
    private final String assessmentRunArn;
    private final String reportFileFormat;
    private final String reportType;

    private GetAssessmentReportRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArn = builder.assessmentRunArn;
        this.reportFileFormat = builder.reportFileFormat;
        this.reportType = builder.reportType;
    }

    public String assessmentRunArn() {
        return this.assessmentRunArn;
    }

    public ReportFileFormat reportFileFormat() {
        return ReportFileFormat.fromValue(this.reportFileFormat);
    }

    public String reportFileFormatAsString() {
        return this.reportFileFormat;
    }

    public ReportType reportType() {
        return ReportType.fromValue(this.reportType);
    }

    public String reportTypeAsString() {
        return this.reportType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssessmentReportRequest)) {
            return false;
        }
        GetAssessmentReportRequest other = (GetAssessmentReportRequest)((Object)obj);
        return Objects.equals(this.assessmentRunArn(), other.assessmentRunArn()) && Objects.equals(this.reportFileFormatAsString(), other.reportFileFormatAsString()) && Objects.equals(this.reportTypeAsString(), other.reportTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetAssessmentReportRequest").add("AssessmentRunArn", (Object)this.assessmentRunArn()).add("ReportFileFormat", (Object)this.reportFileFormatAsString()).add("ReportType", (Object)this.reportTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentRunArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunArn()));
            }
            case "reportFileFormat": {
                return Optional.ofNullable(clazz.cast(this.reportFileFormatAsString()));
            }
            case "reportType": {
                return Optional.ofNullable(clazz.cast(this.reportTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssessmentReportRequest, T> g) {
        return obj -> g.apply((GetAssessmentReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private String assessmentRunArn;
        private String reportFileFormat;
        private String reportType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssessmentReportRequest model) {
            super(model);
            this.assessmentRunArn(model.assessmentRunArn);
            this.reportFileFormat(model.reportFileFormat);
            this.reportType(model.reportType);
        }

        public final String getAssessmentRunArn() {
            return this.assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        public final String getReportFileFormat() {
            return this.reportFileFormat;
        }

        @Override
        public final Builder reportFileFormat(String reportFileFormat) {
            this.reportFileFormat = reportFileFormat;
            return this;
        }

        @Override
        public final Builder reportFileFormat(ReportFileFormat reportFileFormat) {
            this.reportFileFormat(reportFileFormat == null ? null : reportFileFormat.toString());
            return this;
        }

        public final void setReportFileFormat(String reportFileFormat) {
            this.reportFileFormat = reportFileFormat;
        }

        public final String getReportType() {
            return this.reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        @Override
        public final Builder reportType(ReportType reportType) {
            this.reportType(reportType == null ? null : reportType.toString());
            return this;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssessmentReportRequest build() {
            return new GetAssessmentReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssessmentReportRequest> {
        public Builder assessmentRunArn(String var1);

        public Builder reportFileFormat(String var1);

        public Builder reportFileFormat(ReportFileFormat var1);

        public Builder reportType(String var1);

        public Builder reportType(ReportType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

