/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AssessmentTemplateFilter;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.ListParentArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentTemplatesRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, ListAssessmentTemplatesRequest> {
    private static final SdkField<List<String>> ASSESSMENT_TARGET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentTargetArns").getter(ListAssessmentTemplatesRequest.getter(ListAssessmentTemplatesRequest::assessmentTargetArns)).setter(ListAssessmentTemplatesRequest.setter(Builder::assessmentTargetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssessmentTemplateFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ListAssessmentTemplatesRequest.getter(ListAssessmentTemplatesRequest::filter)).setter(ListAssessmentTemplatesRequest.setter(Builder::filter)).constructor(AssessmentTemplateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentTemplatesRequest.getter(ListAssessmentTemplatesRequest::nextToken)).setter(ListAssessmentTemplatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAssessmentTemplatesRequest.getter(ListAssessmentTemplatesRequest::maxResults)).setter(ListAssessmentTemplatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARNS_FIELD, FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> assessmentTargetArns;
    private final AssessmentTemplateFilter filter;
    private final String nextToken;
    private final Integer maxResults;

    private ListAssessmentTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArns = builder.assessmentTargetArns;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public boolean hasAssessmentTargetArns() {
        return this.assessmentTargetArns != null && !(this.assessmentTargetArns instanceof SdkAutoConstructList);
    }

    public List<String> assessmentTargetArns() {
        return this.assessmentTargetArns;
    }

    public AssessmentTemplateFilter filter() {
        return this.filter;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentTargetArns() ? this.assessmentTargetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentTemplatesRequest)) {
            return false;
        }
        ListAssessmentTemplatesRequest other = (ListAssessmentTemplatesRequest)((Object)obj);
        return this.hasAssessmentTargetArns() == other.hasAssessmentTargetArns() && Objects.equals(this.assessmentTargetArns(), other.assessmentTargetArns()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListAssessmentTemplatesRequest").add("AssessmentTargetArns", this.hasAssessmentTargetArns() ? this.assessmentTargetArns() : null).add("Filter", (Object)this.filter()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTargetArns": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargetArns()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentTemplatesRequest, T> g) {
        return obj -> g.apply((ListAssessmentTemplatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> assessmentTargetArns = DefaultSdkAutoConstructList.getInstance();
        private AssessmentTemplateFilter filter;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentTemplatesRequest model) {
            super(model);
            this.assessmentTargetArns(model.assessmentTargetArns);
            this.filter(model.filter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getAssessmentTargetArns() {
            if (this.assessmentTargetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentTargetArns;
        }

        @Override
        public final Builder assessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = ListParentArnListCopier.copy(assessmentTargetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargetArns(String ... assessmentTargetArns) {
            this.assessmentTargetArns(Arrays.asList(assessmentTargetArns));
            return this;
        }

        public final void setAssessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = ListParentArnListCopier.copy(assessmentTargetArns);
        }

        public final AssessmentTemplateFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(AssessmentTemplateFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(AssessmentTemplateFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssessmentTemplatesRequest build() {
            return new ListAssessmentTemplatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentTemplatesRequest> {
        public Builder assessmentTargetArns(Collection<String> var1);

        public Builder assessmentTargetArns(String ... var1);

        public Builder filter(AssessmentTemplateFilter var1);

        default public Builder filter(Consumer<AssessmentTemplateFilter.Builder> filter) {
            return this.filter((AssessmentTemplateFilter)((AssessmentTemplateFilter.Builder)AssessmentTemplateFilter.builder().applyMutation(filter)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

