/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.ResourceGroupTag;
import software.amazon.awssdk.services.inspector.model.ResourceGroupTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceGroupRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, CreateResourceGroupRequest> {
    private static final SdkField<List<ResourceGroupTag>> RESOURCE_GROUP_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceGroupTags").getter(CreateResourceGroupRequest.getter(CreateResourceGroupRequest::resourceGroupTags)).setter(CreateResourceGroupRequest.setter(Builder::resourceGroupTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceGroupTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_TAGS_FIELD));
    private final List<ResourceGroupTag> resourceGroupTags;

    private CreateResourceGroupRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupTags = builder.resourceGroupTags;
    }

    public boolean hasResourceGroupTags() {
        return this.resourceGroupTags != null && !(this.resourceGroupTags instanceof SdkAutoConstructList);
    }

    public List<ResourceGroupTag> resourceGroupTags() {
        return this.resourceGroupTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceGroupTags() ? this.resourceGroupTags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceGroupRequest)) {
            return false;
        }
        CreateResourceGroupRequest other = (CreateResourceGroupRequest)((Object)obj);
        return this.hasResourceGroupTags() == other.hasResourceGroupTags() && Objects.equals(this.resourceGroupTags(), other.resourceGroupTags());
    }

    public String toString() {
        return ToString.builder((String)"CreateResourceGroupRequest").add("ResourceGroupTags", this.hasResourceGroupTags() ? this.resourceGroupTags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceGroupTags": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupTags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceGroupRequest, T> g) {
        return obj -> g.apply((CreateResourceGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<ResourceGroupTag> resourceGroupTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceGroupRequest model) {
            super(model);
            this.resourceGroupTags(model.resourceGroupTags);
        }

        public final Collection<ResourceGroupTag.Builder> getResourceGroupTags() {
            if (this.resourceGroupTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceGroupTags != null ? (Collection)this.resourceGroupTags.stream().map(ResourceGroupTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceGroupTags(Collection<ResourceGroupTag> resourceGroupTags) {
            this.resourceGroupTags = ResourceGroupTagsCopier.copy(resourceGroupTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupTags(ResourceGroupTag ... resourceGroupTags) {
            this.resourceGroupTags(Arrays.asList(resourceGroupTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupTags(Consumer<ResourceGroupTag.Builder> ... resourceGroupTags) {
            this.resourceGroupTags(Stream.of(resourceGroupTags).map(c -> (ResourceGroupTag)((ResourceGroupTag.Builder)ResourceGroupTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceGroupTags(Collection<ResourceGroupTag.BuilderImpl> resourceGroupTags) {
            this.resourceGroupTags = ResourceGroupTagsCopier.copyFromBuilder(resourceGroupTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceGroupRequest build() {
            return new CreateResourceGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceGroupRequest> {
        public Builder resourceGroupTags(Collection<ResourceGroupTag> var1);

        public Builder resourceGroupTags(ResourceGroupTag ... var1);

        public Builder resourceGroupTags(Consumer<ResourceGroupTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

