/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an Amazon Inspector agent. This data type is used as a response element in the
 * <a>ListAssessmentRunAgents</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentRunAgent implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentRunAgent.Builder, AssessmentRunAgent> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AssessmentRunAgent::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentRunArn").getter(getter(AssessmentRunAgent::assessmentRunArn))
            .setter(setter(Builder::assessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()).build();

    private static final SdkField<String> AGENT_HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentHealth").getter(getter(AssessmentRunAgent::agentHealthAsString))
            .setter(setter(Builder::agentHealth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealth").build()).build();

    private static final SdkField<String> AGENT_HEALTH_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentHealthCode").getter(getter(AssessmentRunAgent::agentHealthCodeAsString))
            .setter(setter(Builder::agentHealthCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealthCode").build()).build();

    private static final SdkField<String> AGENT_HEALTH_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentHealthDetails").getter(getter(AssessmentRunAgent::agentHealthDetails))
            .setter(setter(Builder::agentHealthDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealthDetails").build())
            .build();

    private static final SdkField<String> AUTO_SCALING_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoScalingGroup").getter(getter(AssessmentRunAgent::autoScalingGroup))
            .setter(setter(Builder::autoScalingGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroup").build()).build();

    private static final SdkField<List<TelemetryMetadata>> TELEMETRY_METADATA_FIELD = SdkField
            .<List<TelemetryMetadata>> builder(MarshallingType.LIST)
            .memberName("telemetryMetadata")
            .getter(getter(AssessmentRunAgent::telemetryMetadata))
            .setter(setter(Builder::telemetryMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telemetryMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TelemetryMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(TelemetryMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            ASSESSMENT_RUN_ARN_FIELD, AGENT_HEALTH_FIELD, AGENT_HEALTH_CODE_FIELD, AGENT_HEALTH_DETAILS_FIELD,
            AUTO_SCALING_GROUP_FIELD, TELEMETRY_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String assessmentRunArn;

    private final String agentHealth;

    private final String agentHealthCode;

    private final String agentHealthDetails;

    private final String autoScalingGroup;

    private final List<TelemetryMetadata> telemetryMetadata;

    private AssessmentRunAgent(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.assessmentRunArn = builder.assessmentRunArn;
        this.agentHealth = builder.agentHealth;
        this.agentHealthCode = builder.agentHealthCode;
        this.agentHealthDetails = builder.agentHealthDetails;
        this.autoScalingGroup = builder.autoScalingGroup;
        this.telemetryMetadata = builder.telemetryMetadata;
    }

    /**
     * <p>
     * The AWS account of the EC2 instance where the agent is installed.
     * </p>
     * 
     * @return The AWS account of the EC2 instance where the agent is installed.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The ARN of the assessment run that is associated with the agent.
     * </p>
     * 
     * @return The ARN of the assessment run that is associated with the agent.
     */
    public final String assessmentRunArn() {
        return assessmentRunArn;
    }

    /**
     * <p>
     * The current health state of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentHealth} will
     * return {@link AgentHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentHealthAsString}.
     * </p>
     * 
     * @return The current health state of the agent.
     * @see AgentHealth
     */
    public final AgentHealth agentHealth() {
        return AgentHealth.fromValue(agentHealth);
    }

    /**
     * <p>
     * The current health state of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentHealth} will
     * return {@link AgentHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentHealthAsString}.
     * </p>
     * 
     * @return The current health state of the agent.
     * @see AgentHealth
     */
    public final String agentHealthAsString() {
        return agentHealth;
    }

    /**
     * <p>
     * The detailed health state of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentHealthCode}
     * will return {@link AgentHealthCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #agentHealthCodeAsString}.
     * </p>
     * 
     * @return The detailed health state of the agent.
     * @see AgentHealthCode
     */
    public final AgentHealthCode agentHealthCode() {
        return AgentHealthCode.fromValue(agentHealthCode);
    }

    /**
     * <p>
     * The detailed health state of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentHealthCode}
     * will return {@link AgentHealthCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #agentHealthCodeAsString}.
     * </p>
     * 
     * @return The detailed health state of the agent.
     * @see AgentHealthCode
     */
    public final String agentHealthCodeAsString() {
        return agentHealthCode;
    }

    /**
     * <p>
     * The description for the agent health code.
     * </p>
     * 
     * @return The description for the agent health code.
     */
    public final String agentHealthDetails() {
        return agentHealthDetails;
    }

    /**
     * <p>
     * The Auto Scaling group of the EC2 instance that is specified by the agent ID.
     * </p>
     * 
     * @return The Auto Scaling group of the EC2 instance that is specified by the agent ID.
     */
    public final String autoScalingGroup() {
        return autoScalingGroup;
    }

    /**
     * Returns true if the TelemetryMetadata property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTelemetryMetadata() {
        return telemetryMetadata != null && !(telemetryMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Inspector application data metrics that are collected by the agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTelemetryMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Inspector application data metrics that are collected by the agent.
     */
    public final List<TelemetryMetadata> telemetryMetadata() {
        return telemetryMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentHealthCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentHealthDetails());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasTelemetryMetadata() ? telemetryMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunAgent)) {
            return false;
        }
        AssessmentRunAgent other = (AssessmentRunAgent) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(assessmentRunArn(), other.assessmentRunArn())
                && Objects.equals(agentHealthAsString(), other.agentHealthAsString())
                && Objects.equals(agentHealthCodeAsString(), other.agentHealthCodeAsString())
                && Objects.equals(agentHealthDetails(), other.agentHealthDetails())
                && Objects.equals(autoScalingGroup(), other.autoScalingGroup())
                && hasTelemetryMetadata() == other.hasTelemetryMetadata()
                && Objects.equals(telemetryMetadata(), other.telemetryMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentRunAgent").add("AgentId", agentId()).add("AssessmentRunArn", assessmentRunArn())
                .add("AgentHealth", agentHealthAsString()).add("AgentHealthCode", agentHealthCodeAsString())
                .add("AgentHealthDetails", agentHealthDetails()).add("AutoScalingGroup", autoScalingGroup())
                .add("TelemetryMetadata", hasTelemetryMetadata() ? telemetryMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "assessmentRunArn":
            return Optional.ofNullable(clazz.cast(assessmentRunArn()));
        case "agentHealth":
            return Optional.ofNullable(clazz.cast(agentHealthAsString()));
        case "agentHealthCode":
            return Optional.ofNullable(clazz.cast(agentHealthCodeAsString()));
        case "agentHealthDetails":
            return Optional.ofNullable(clazz.cast(agentHealthDetails()));
        case "autoScalingGroup":
            return Optional.ofNullable(clazz.cast(autoScalingGroup()));
        case "telemetryMetadata":
            return Optional.ofNullable(clazz.cast(telemetryMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunAgent, T> g) {
        return obj -> g.apply((AssessmentRunAgent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentRunAgent> {
        /**
         * <p>
         * The AWS account of the EC2 instance where the agent is installed.
         * </p>
         * 
         * @param agentId
         *        The AWS account of the EC2 instance where the agent is installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The ARN of the assessment run that is associated with the agent.
         * </p>
         * 
         * @param assessmentRunArn
         *        The ARN of the assessment run that is associated with the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArn(String assessmentRunArn);

        /**
         * <p>
         * The current health state of the agent.
         * </p>
         * 
         * @param agentHealth
         *        The current health state of the agent.
         * @see AgentHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentHealth
         */
        Builder agentHealth(String agentHealth);

        /**
         * <p>
         * The current health state of the agent.
         * </p>
         * 
         * @param agentHealth
         *        The current health state of the agent.
         * @see AgentHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentHealth
         */
        Builder agentHealth(AgentHealth agentHealth);

        /**
         * <p>
         * The detailed health state of the agent.
         * </p>
         * 
         * @param agentHealthCode
         *        The detailed health state of the agent.
         * @see AgentHealthCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentHealthCode
         */
        Builder agentHealthCode(String agentHealthCode);

        /**
         * <p>
         * The detailed health state of the agent.
         * </p>
         * 
         * @param agentHealthCode
         *        The detailed health state of the agent.
         * @see AgentHealthCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentHealthCode
         */
        Builder agentHealthCode(AgentHealthCode agentHealthCode);

        /**
         * <p>
         * The description for the agent health code.
         * </p>
         * 
         * @param agentHealthDetails
         *        The description for the agent health code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthDetails(String agentHealthDetails);

        /**
         * <p>
         * The Auto Scaling group of the EC2 instance that is specified by the agent ID.
         * </p>
         * 
         * @param autoScalingGroup
         *        The Auto Scaling group of the EC2 instance that is specified by the agent ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroup(String autoScalingGroup);

        /**
         * <p>
         * The Amazon Inspector application data metrics that are collected by the agent.
         * </p>
         * 
         * @param telemetryMetadata
         *        The Amazon Inspector application data metrics that are collected by the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryMetadata(Collection<TelemetryMetadata> telemetryMetadata);

        /**
         * <p>
         * The Amazon Inspector application data metrics that are collected by the agent.
         * </p>
         * 
         * @param telemetryMetadata
         *        The Amazon Inspector application data metrics that are collected by the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryMetadata(TelemetryMetadata... telemetryMetadata);

        /**
         * <p>
         * The Amazon Inspector application data metrics that are collected by the agent.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TelemetryMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<TelemetryMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TelemetryMetadata>.Builder#build()} is called immediately
         * and its result is passed to {@link #telemetryMetadata(List<TelemetryMetadata>)}.
         * 
         * @param telemetryMetadata
         *        a consumer that will call methods on {@link List<TelemetryMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryMetadata(List<TelemetryMetadata>)
         */
        Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder>... telemetryMetadata);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String assessmentRunArn;

        private String agentHealth;

        private String agentHealthCode;

        private String agentHealthDetails;

        private String autoScalingGroup;

        private List<TelemetryMetadata> telemetryMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunAgent model) {
            agentId(model.agentId);
            assessmentRunArn(model.assessmentRunArn);
            agentHealth(model.agentHealth);
            agentHealthCode(model.agentHealthCode);
            agentHealthDetails(model.agentHealthDetails);
            autoScalingGroup(model.autoScalingGroup);
            telemetryMetadata(model.telemetryMetadata);
        }

        public final String getAgentId() {
            return agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public final String getAssessmentRunArn() {
            return assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        public final String getAgentHealth() {
            return agentHealth;
        }

        @Override
        public final Builder agentHealth(String agentHealth) {
            this.agentHealth = agentHealth;
            return this;
        }

        @Override
        public final Builder agentHealth(AgentHealth agentHealth) {
            this.agentHealth(agentHealth == null ? null : agentHealth.toString());
            return this;
        }

        public final void setAgentHealth(String agentHealth) {
            this.agentHealth = agentHealth;
        }

        public final String getAgentHealthCode() {
            return agentHealthCode;
        }

        @Override
        public final Builder agentHealthCode(String agentHealthCode) {
            this.agentHealthCode = agentHealthCode;
            return this;
        }

        @Override
        public final Builder agentHealthCode(AgentHealthCode agentHealthCode) {
            this.agentHealthCode(agentHealthCode == null ? null : agentHealthCode.toString());
            return this;
        }

        public final void setAgentHealthCode(String agentHealthCode) {
            this.agentHealthCode = agentHealthCode;
        }

        public final String getAgentHealthDetails() {
            return agentHealthDetails;
        }

        @Override
        public final Builder agentHealthDetails(String agentHealthDetails) {
            this.agentHealthDetails = agentHealthDetails;
            return this;
        }

        public final void setAgentHealthDetails(String agentHealthDetails) {
            this.agentHealthDetails = agentHealthDetails;
        }

        public final String getAutoScalingGroup() {
            return autoScalingGroup;
        }

        @Override
        public final Builder autoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        public final void setAutoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
        }

        public final Collection<TelemetryMetadata.Builder> getTelemetryMetadata() {
            if (telemetryMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return telemetryMetadata != null ? telemetryMetadata.stream().map(TelemetryMetadata::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder telemetryMetadata(Collection<TelemetryMetadata> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copy(telemetryMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(TelemetryMetadata... telemetryMetadata) {
            telemetryMetadata(Arrays.asList(telemetryMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder>... telemetryMetadata) {
            telemetryMetadata(Stream.of(telemetryMetadata).map(c -> TelemetryMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTelemetryMetadata(Collection<TelemetryMetadata.BuilderImpl> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copyFromBuilder(telemetryMetadata);
        }

        @Override
        public AssessmentRunAgent build() {
            return new AssessmentRunAgent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
