/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used in the <a>Subscription</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<EventSubscription.Builder, EventSubscription> {
    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("event")
            .getter(getter(EventSubscription::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<Instant> SUBSCRIBED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("subscribedAt").getter(getter(EventSubscription::subscribedAt)).setter(setter(Builder::subscribedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD,
            SUBSCRIBED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String event;

    private final Instant subscribedAt;

    private EventSubscription(BuilderImpl builder) {
        this.event = builder.event;
        this.subscribedAt = builder.subscribedAt;
    }

    /**
     * <p>
     * The event for which Amazon Simple Notification Service (SNS) notifications are sent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link InspectorEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event for which Amazon Simple Notification Service (SNS) notifications are sent.
     * @see InspectorEvent
     */
    public final InspectorEvent event() {
        return InspectorEvent.fromValue(event);
    }

    /**
     * <p>
     * The event for which Amazon Simple Notification Service (SNS) notifications are sent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link InspectorEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event for which Amazon Simple Notification Service (SNS) notifications are sent.
     * @see InspectorEvent
     */
    public final String eventAsString() {
        return event;
    }

    /**
     * <p>
     * The time at which <a>SubscribeToEvent</a> is called.
     * </p>
     * 
     * @return The time at which <a>SubscribeToEvent</a> is called.
     */
    public final Instant subscribedAt() {
        return subscribedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription) obj;
        return Objects.equals(eventAsString(), other.eventAsString()) && Objects.equals(subscribedAt(), other.subscribedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSubscription").add("Event", eventAsString()).add("SubscribedAt", subscribedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "subscribedAt":
            return Optional.ofNullable(clazz.cast(subscribedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSubscription, T> g) {
        return obj -> g.apply((EventSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSubscription> {
        /**
         * <p>
         * The event for which Amazon Simple Notification Service (SNS) notifications are sent.
         * </p>
         * 
         * @param event
         *        The event for which Amazon Simple Notification Service (SNS) notifications are sent.
         * @see InspectorEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectorEvent
         */
        Builder event(String event);

        /**
         * <p>
         * The event for which Amazon Simple Notification Service (SNS) notifications are sent.
         * </p>
         * 
         * @param event
         *        The event for which Amazon Simple Notification Service (SNS) notifications are sent.
         * @see InspectorEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectorEvent
         */
        Builder event(InspectorEvent event);

        /**
         * <p>
         * The time at which <a>SubscribeToEvent</a> is called.
         * </p>
         * 
         * @param subscribedAt
         *        The time at which <a>SubscribeToEvent</a> is called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedAt(Instant subscribedAt);
    }

    static final class BuilderImpl implements Builder {
        private String event;

        private Instant subscribedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            event(model.event);
            subscribedAt(model.subscribedAt);
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(InspectorEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final Instant getSubscribedAt() {
            return subscribedAt;
        }

        @Override
        public final Builder subscribedAt(Instant subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        public final void setSubscribedAt(Instant subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        public EventSubscription build() {
            return new EventSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
