/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssessmentRunRequest extends InspectorRequest implements
        ToCopyableBuilder<StartAssessmentRunRequest.Builder, StartAssessmentRunRequest> {
    private static final SdkField<String> ASSESSMENT_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentTemplateArn").getter(getter(StartAssessmentRunRequest::assessmentTemplateArn))
            .setter(setter(Builder::assessmentTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArn").build())
            .build();

    private static final SdkField<String> ASSESSMENT_RUN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentRunName").getter(getter(StartAssessmentRunRequest::assessmentRunName))
            .setter(setter(Builder::assessmentRunName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TEMPLATE_ARN_FIELD,
            ASSESSMENT_RUN_NAME_FIELD));

    private final String assessmentTemplateArn;

    private final String assessmentRunName;

    private StartAssessmentRunRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplateArn = builder.assessmentTemplateArn;
        this.assessmentRunName = builder.assessmentRunName;
    }

    /**
     * <p>
     * The ARN of the assessment template of the assessment run that you want to start.
     * </p>
     * 
     * @return The ARN of the assessment template of the assessment run that you want to start.
     */
    public final String assessmentTemplateArn() {
        return assessmentTemplateArn;
    }

    /**
     * <p>
     * You can specify the name for the assessment run. The name must be unique for the assessment template whose ARN is
     * used to start the assessment run.
     * </p>
     * 
     * @return You can specify the name for the assessment run. The name must be unique for the assessment template
     *         whose ARN is used to start the assessment run.
     */
    public final String assessmentRunName() {
        return assessmentRunName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentRunRequest)) {
            return false;
        }
        StartAssessmentRunRequest other = (StartAssessmentRunRequest) obj;
        return Objects.equals(assessmentTemplateArn(), other.assessmentTemplateArn())
                && Objects.equals(assessmentRunName(), other.assessmentRunName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssessmentRunRequest").add("AssessmentTemplateArn", assessmentTemplateArn())
                .add("AssessmentRunName", assessmentRunName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTemplateArn":
            return Optional.ofNullable(clazz.cast(assessmentTemplateArn()));
        case "assessmentRunName":
            return Optional.ofNullable(clazz.cast(assessmentRunName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentRunRequest, T> g) {
        return obj -> g.apply((StartAssessmentRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartAssessmentRunRequest> {
        /**
         * <p>
         * The ARN of the assessment template of the assessment run that you want to start.
         * </p>
         * 
         * @param assessmentTemplateArn
         *        The ARN of the assessment template of the assessment run that you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTemplateArn(String assessmentTemplateArn);

        /**
         * <p>
         * You can specify the name for the assessment run. The name must be unique for the assessment template whose
         * ARN is used to start the assessment run.
         * </p>
         * 
         * @param assessmentRunName
         *        You can specify the name for the assessment run. The name must be unique for the assessment template
         *        whose ARN is used to start the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunName(String assessmentRunName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String assessmentTemplateArn;

        private String assessmentRunName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentRunRequest model) {
            super(model);
            assessmentTemplateArn(model.assessmentTemplateArn);
            assessmentRunName(model.assessmentRunName);
        }

        public final String getAssessmentTemplateArn() {
            return assessmentTemplateArn;
        }

        @Override
        public final Builder assessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
            return this;
        }

        public final void setAssessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
        }

        public final String getAssessmentRunName() {
            return assessmentRunName;
        }

        @Override
        public final Builder assessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
            return this;
        }

        public final void setAssessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssessmentRunRequest build() {
            return new StartAssessmentRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
