/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.BatchDescribeArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssessmentTargetsRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, DescribeAssessmentTargetsRequest> {
    private static final SdkField<List<String>> ASSESSMENT_TARGET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentTargetArns").getter(DescribeAssessmentTargetsRequest.getter(DescribeAssessmentTargetsRequest::assessmentTargetArns)).setter(DescribeAssessmentTargetsRequest.setter(Builder::assessmentTargetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARNS_FIELD));
    private final List<String> assessmentTargetArns;

    private DescribeAssessmentTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArns = builder.assessmentTargetArns;
    }

    public final boolean hasAssessmentTargetArns() {
        return this.assessmentTargetArns != null && !(this.assessmentTargetArns instanceof SdkAutoConstructList);
    }

    public final List<String> assessmentTargetArns() {
        return this.assessmentTargetArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentTargetArns() ? this.assessmentTargetArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentTargetsRequest)) {
            return false;
        }
        DescribeAssessmentTargetsRequest other = (DescribeAssessmentTargetsRequest)((Object)obj);
        return this.hasAssessmentTargetArns() == other.hasAssessmentTargetArns() && Objects.equals(this.assessmentTargetArns(), other.assessmentTargetArns());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssessmentTargetsRequest").add("AssessmentTargetArns", this.hasAssessmentTargetArns() ? this.assessmentTargetArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTargetArns": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargetArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentTargetsRequest, T> g) {
        return obj -> g.apply((DescribeAssessmentTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> assessmentTargetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentTargetsRequest model) {
            super(model);
            this.assessmentTargetArns(model.assessmentTargetArns);
        }

        public final Collection<String> getAssessmentTargetArns() {
            if (this.assessmentTargetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentTargetArns;
        }

        @Override
        public final Builder assessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = BatchDescribeArnListCopier.copy(assessmentTargetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargetArns(String ... assessmentTargetArns) {
            this.assessmentTargetArns(Arrays.asList(assessmentTargetArns));
            return this;
        }

        public final void setAssessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = BatchDescribeArnListCopier.copy(assessmentTargetArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssessmentTargetsRequest build() {
            return new DescribeAssessmentTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssessmentTargetsRequest> {
        public Builder assessmentTargetArns(Collection<String> var1);

        public Builder assessmentTargetArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

