/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of attributes of the host from which the finding is generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetAttributes implements SdkPojo, Serializable, ToCopyableBuilder<AssetAttributes.Builder, AssetAttributes> {
    private static final SdkField<Integer> SCHEMA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("schemaVersion").getter(getter(AssetAttributes::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AssetAttributes::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AUTO_SCALING_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoScalingGroup").getter(getter(AssetAttributes::autoScalingGroup))
            .setter(setter(Builder::autoScalingGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroup").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("amiId")
            .getter(getter(AssetAttributes::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiId").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(AssetAttributes::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<List<String>> IPV4_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipv4Addresses")
            .getter(getter(AssetAttributes::ipv4Addresses))
            .setter(setter(Builder::ipv4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv4Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(AssetAttributes::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField
            .<List<NetworkInterface>> builder(MarshallingType.LIST)
            .memberName("networkInterfaces")
            .getter(getter(AssetAttributes::networkInterfaces))
            .setter(setter(Builder::networkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkInterface> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkInterface::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_FIELD,
            AGENT_ID_FIELD, AUTO_SCALING_GROUP_FIELD, AMI_ID_FIELD, HOSTNAME_FIELD, IPV4_ADDRESSES_FIELD, TAGS_FIELD,
            NETWORK_INTERFACES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer schemaVersion;

    private final String agentId;

    private final String autoScalingGroup;

    private final String amiId;

    private final String hostname;

    private final List<String> ipv4Addresses;

    private final List<Tag> tags;

    private final List<NetworkInterface> networkInterfaces;

    private AssetAttributes(BuilderImpl builder) {
        this.schemaVersion = builder.schemaVersion;
        this.agentId = builder.agentId;
        this.autoScalingGroup = builder.autoScalingGroup;
        this.amiId = builder.amiId;
        this.hostname = builder.hostname;
        this.ipv4Addresses = builder.ipv4Addresses;
        this.tags = builder.tags;
        this.networkInterfaces = builder.networkInterfaces;
    }

    /**
     * <p>
     * The schema version of this data type.
     * </p>
     * 
     * @return The schema version of this data type.
     */
    public final Integer schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The ID of the agent that is installed on the EC2 instance where the finding is generated.
     * </p>
     * 
     * @return The ID of the agent that is installed on the EC2 instance where the finding is generated.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The Auto Scaling group of the EC2 instance where the finding is generated.
     * </p>
     * 
     * @return The Auto Scaling group of the EC2 instance where the finding is generated.
     */
    public final String autoScalingGroup() {
        return autoScalingGroup;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where the finding is generated.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where the finding is
     *         generated.
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The hostname of the EC2 instance where the finding is generated.
     * </p>
     * 
     * @return The hostname of the EC2 instance where the finding is generated.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * Returns true if the Ipv4Addresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv4Addresses() {
        return ipv4Addresses != null && !(ipv4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of IP v4 addresses of the EC2 instance where the finding is generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv4Addresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of IP v4 addresses of the EC2 instance where the finding is generated.
     */
    public final List<String> ipv4Addresses() {
        return ipv4Addresses;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags related to the EC2 instance where the finding is generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags related to the EC2 instance where the finding is generated.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the NetworkInterfaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNetworkInterfaces() {
        return networkInterfaces != null && !(networkInterfaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the network interfaces interacting with the EC2 instance where the finding is generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNetworkInterfaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of the network interfaces interacting with the EC2 instance where the finding is generated.
     */
    public final List<NetworkInterface> networkInterfaces() {
        return networkInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Addresses() ? ipv4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaces() ? networkInterfaces() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetAttributes)) {
            return false;
        }
        AssetAttributes other = (AssetAttributes) obj;
        return Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(autoScalingGroup(), other.autoScalingGroup()) && Objects.equals(amiId(), other.amiId())
                && Objects.equals(hostname(), other.hostname()) && hasIpv4Addresses() == other.hasIpv4Addresses()
                && Objects.equals(ipv4Addresses(), other.ipv4Addresses()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasNetworkInterfaces() == other.hasNetworkInterfaces()
                && Objects.equals(networkInterfaces(), other.networkInterfaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetAttributes").add("SchemaVersion", schemaVersion()).add("AgentId", agentId())
                .add("AutoScalingGroup", autoScalingGroup()).add("AmiId", amiId()).add("Hostname", hostname())
                .add("Ipv4Addresses", hasIpv4Addresses() ? ipv4Addresses() : null).add("Tags", hasTags() ? tags() : null)
                .add("NetworkInterfaces", hasNetworkInterfaces() ? networkInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "autoScalingGroup":
            return Optional.ofNullable(clazz.cast(autoScalingGroup()));
        case "amiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "ipv4Addresses":
            return Optional.ofNullable(clazz.cast(ipv4Addresses()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "networkInterfaces":
            return Optional.ofNullable(clazz.cast(networkInterfaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetAttributes, T> g) {
        return obj -> g.apply((AssetAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetAttributes> {
        /**
         * <p>
         * The schema version of this data type.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version of this data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(Integer schemaVersion);

        /**
         * <p>
         * The ID of the agent that is installed on the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param agentId
         *        The ID of the agent that is installed on the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The Auto Scaling group of the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param autoScalingGroup
         *        The Auto Scaling group of the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroup(String autoScalingGroup);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where the finding is
         * generated.
         * </p>
         * 
         * @param amiId
         *        The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance where the finding is
         *        generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The hostname of the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param hostname
         *        The hostname of the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The list of IP v4 addresses of the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param ipv4Addresses
         *        The list of IP v4 addresses of the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Addresses(Collection<String> ipv4Addresses);

        /**
         * <p>
         * The list of IP v4 addresses of the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param ipv4Addresses
         *        The list of IP v4 addresses of the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Addresses(String... ipv4Addresses);

        /**
         * <p>
         * The tags related to the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param tags
         *        The tags related to the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags related to the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param tags
         *        The tags related to the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags related to the EC2 instance where the finding is generated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An array of the network interfaces interacting with the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param networkInterfaces
         *        An array of the network interfaces interacting with the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces);

        /**
         * <p>
         * An array of the network interfaces interacting with the EC2 instance where the finding is generated.
         * </p>
         * 
         * @param networkInterfaces
         *        An array of the network interfaces interacting with the EC2 instance where the finding is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(NetworkInterface... networkInterfaces);

        /**
         * <p>
         * An array of the network interfaces interacting with the EC2 instance where the finding is generated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterface>.Builder} avoiding the
         * need to create one manually via {@link List<NetworkInterface>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterface>.Builder#build()} is called immediately and
         * its result is passed to {@link #networkInterfaces(List<NetworkInterface>)}.
         * 
         * @param networkInterfaces
         *        a consumer that will call methods on {@link List<NetworkInterface>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaces(List<NetworkInterface>)
         */
        Builder networkInterfaces(Consumer<NetworkInterface.Builder>... networkInterfaces);
    }

    static final class BuilderImpl implements Builder {
        private Integer schemaVersion;

        private String agentId;

        private String autoScalingGroup;

        private String amiId;

        private String hostname;

        private List<String> ipv4Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetAttributes model) {
            schemaVersion(model.schemaVersion);
            agentId(model.agentId);
            autoScalingGroup(model.autoScalingGroup);
            amiId(model.amiId);
            hostname(model.hostname);
            ipv4Addresses(model.ipv4Addresses);
            tags(model.tags);
            networkInterfaces(model.networkInterfaces);
        }

        public final Integer getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getAgentId() {
            return agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public final String getAutoScalingGroup() {
            return autoScalingGroup;
        }

        @Override
        public final Builder autoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        public final void setAutoScalingGroup(String autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final Collection<String> getIpv4Addresses() {
            if (ipv4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv4Addresses;
        }

        @Override
        public final Builder ipv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = Ipv4AddressListCopier.copy(ipv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Addresses(String... ipv4Addresses) {
            ipv4Addresses(Arrays.asList(ipv4Addresses));
            return this;
        }

        public final void setIpv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = Ipv4AddressListCopier.copy(ipv4Addresses);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder>... networkInterfaces) {
            networkInterfaces(Stream.of(networkInterfaces).map(c -> NetworkInterface.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public AssetAttributes build() {
            return new AssetAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
