/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFindingsRequest extends InspectorRequest implements
        ToCopyableBuilder<DescribeFindingsRequest.Builder, DescribeFindingsRequest> {
    private static final SdkField<List<String>> FINDING_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("findingArns")
            .getter(getter(DescribeFindingsRequest::findingArns))
            .setter(setter(Builder::findingArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(DescribeFindingsRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ARNS_FIELD,
            LOCALE_FIELD));

    private final List<String> findingArns;

    private final String locale;

    private DescribeFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingArns = builder.findingArns;
        this.locale = builder.locale;
    }

    /**
     * Returns true if the FindingArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFindingArns() {
        return findingArns != null && !(findingArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN that specifies the finding that you want to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARN that specifies the finding that you want to describe.
     */
    public final List<String> findingArns() {
        return findingArns;
    }

    /**
     * <p>
     * The locale into which you want to translate a finding description, recommendation, and the short description that
     * identifies the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale into which you want to translate a finding description, recommendation, and the short
     *         description that identifies the finding.
     * @see Locale
     */
    public final Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * The locale into which you want to translate a finding description, recommendation, and the short description that
     * identifies the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale into which you want to translate a finding description, recommendation, and the short
     *         description that identifies the finding.
     * @see Locale
     */
    public final String localeAsString() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingArns() ? findingArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFindingsRequest)) {
            return false;
        }
        DescribeFindingsRequest other = (DescribeFindingsRequest) obj;
        return hasFindingArns() == other.hasFindingArns() && Objects.equals(findingArns(), other.findingArns())
                && Objects.equals(localeAsString(), other.localeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFindingsRequest").add("FindingArns", hasFindingArns() ? findingArns() : null)
                .add("Locale", localeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingArns":
            return Optional.ofNullable(clazz.cast(findingArns()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFindingsRequest, T> g) {
        return obj -> g.apply((DescribeFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFindingsRequest> {
        /**
         * <p>
         * The ARN that specifies the finding that you want to describe.
         * </p>
         * 
         * @param findingArns
         *        The ARN that specifies the finding that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArns(Collection<String> findingArns);

        /**
         * <p>
         * The ARN that specifies the finding that you want to describe.
         * </p>
         * 
         * @param findingArns
         *        The ARN that specifies the finding that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArns(String... findingArns);

        /**
         * <p>
         * The locale into which you want to translate a finding description, recommendation, and the short description
         * that identifies the finding.
         * </p>
         * 
         * @param locale
         *        The locale into which you want to translate a finding description, recommendation, and the short
         *        description that identifies the finding.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale into which you want to translate a finding description, recommendation, and the short description
         * that identifies the finding.
         * </p>
         * 
         * @param locale
         *        The locale into which you want to translate a finding description, recommendation, and the short
         *        description that identifies the finding.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private List<String> findingArns = DefaultSdkAutoConstructList.getInstance();

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFindingsRequest model) {
            super(model);
            findingArns(model.findingArns);
            locale(model.locale);
        }

        public final Collection<String> getFindingArns() {
            if (findingArns instanceof SdkAutoConstructList) {
                return null;
            }
            return findingArns;
        }

        @Override
        public final Builder findingArns(Collection<String> findingArns) {
            this.findingArns = BatchDescribeArnListCopier.copy(findingArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingArns(String... findingArns) {
            findingArns(Arrays.asList(findingArns));
            return this;
        }

        public final void setFindingArns(Collection<String> findingArns) {
            this.findingArns = BatchDescribeArnListCopier.copy(findingArns);
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFindingsRequest build() {
            return new DescribeFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
