/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExclusionsPreviewRequest extends InspectorRequest implements
        ToCopyableBuilder<GetExclusionsPreviewRequest.Builder, GetExclusionsPreviewRequest> {
    private static final SdkField<String> ASSESSMENT_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentTemplateArn").getter(getter(GetExclusionsPreviewRequest::assessmentTemplateArn))
            .setter(setter(Builder::assessmentTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArn").build())
            .build();

    private static final SdkField<String> PREVIEW_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("previewToken").getter(getter(GetExclusionsPreviewRequest::previewToken))
            .setter(setter(Builder::previewToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewToken").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetExclusionsPreviewRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetExclusionsPreviewRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(GetExclusionsPreviewRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TEMPLATE_ARN_FIELD,
            PREVIEW_TOKEN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LOCALE_FIELD));

    private final String assessmentTemplateArn;

    private final String previewToken;

    private final String nextToken;

    private final Integer maxResults;

    private final String locale;

    private GetExclusionsPreviewRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplateArn = builder.assessmentTemplateArn;
        this.previewToken = builder.previewToken;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.locale = builder.locale;
    }

    /**
     * <p>
     * The ARN that specifies the assessment template for which the exclusions preview was requested.
     * </p>
     * 
     * @return The ARN that specifies the assessment template for which the exclusions preview was requested.
     */
    public final String assessmentTemplateArn() {
        return assessmentTemplateArn;
    }

    /**
     * <p>
     * The unique identifier associated of the exclusions preview.
     * </p>
     * 
     * @return The unique identifier associated of the exclusions preview.
     */
    public final String previewToken() {
        return previewToken;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in the request with the
     * value of nextToken from the previous response to continue listing data.
     * </p>
     * 
     * @return You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *         call to the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in the
     *         request with the value of nextToken from the previous response to continue listing data.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * You can use this parameter to indicate the maximum number of items you want in the response. The default value is
     * 100. The maximum value is 500.
     * </p>
     * 
     * @return You can use this parameter to indicate the maximum number of items you want in the response. The default
     *         value is 100. The maximum value is 500.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The locale into which you want to translate the exclusion's title, description, and recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale into which you want to translate the exclusion's title, description, and recommendation.
     * @see Locale
     */
    public final Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * The locale into which you want to translate the exclusion's title, description, and recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale into which you want to translate the exclusion's title, description, and recommendation.
     * @see Locale
     */
    public final String localeAsString() {
        return locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(previewToken());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExclusionsPreviewRequest)) {
            return false;
        }
        GetExclusionsPreviewRequest other = (GetExclusionsPreviewRequest) obj;
        return Objects.equals(assessmentTemplateArn(), other.assessmentTemplateArn())
                && Objects.equals(previewToken(), other.previewToken()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(localeAsString(), other.localeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExclusionsPreviewRequest").add("AssessmentTemplateArn", assessmentTemplateArn())
                .add("PreviewToken", previewToken()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Locale", localeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTemplateArn":
            return Optional.ofNullable(clazz.cast(assessmentTemplateArn()));
        case "previewToken":
            return Optional.ofNullable(clazz.cast(previewToken()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExclusionsPreviewRequest, T> g) {
        return obj -> g.apply((GetExclusionsPreviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetExclusionsPreviewRequest> {
        /**
         * <p>
         * The ARN that specifies the assessment template for which the exclusions preview was requested.
         * </p>
         * 
         * @param assessmentTemplateArn
         *        The ARN that specifies the assessment template for which the exclusions preview was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTemplateArn(String assessmentTemplateArn);

        /**
         * <p>
         * The unique identifier associated of the exclusions preview.
         * </p>
         * 
         * @param previewToken
         *        The unique identifier associated of the exclusions preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previewToken(String previewToken);

        /**
         * <p>
         * You can use this parameter when paginating results. Set the value of this parameter to null on your first
         * call to the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in the request
         * with the value of nextToken from the previous response to continue listing data.
         * </p>
         * 
         * @param nextToken
         *        You can use this parameter when paginating results. Set the value of this parameter to null on your
         *        first call to the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in
         *        the request with the value of nextToken from the previous response to continue listing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * You can use this parameter to indicate the maximum number of items you want in the response. The default
         * value is 100. The maximum value is 500.
         * </p>
         * 
         * @param maxResults
         *        You can use this parameter to indicate the maximum number of items you want in the response. The
         *        default value is 100. The maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The locale into which you want to translate the exclusion's title, description, and recommendation.
         * </p>
         * 
         * @param locale
         *        The locale into which you want to translate the exclusion's title, description, and recommendation.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale into which you want to translate the exclusion's title, description, and recommendation.
         * </p>
         * 
         * @param locale
         *        The locale into which you want to translate the exclusion's title, description, and recommendation.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String assessmentTemplateArn;

        private String previewToken;

        private String nextToken;

        private Integer maxResults;

        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExclusionsPreviewRequest model) {
            super(model);
            assessmentTemplateArn(model.assessmentTemplateArn);
            previewToken(model.previewToken);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            locale(model.locale);
        }

        public final String getAssessmentTemplateArn() {
            return assessmentTemplateArn;
        }

        @Override
        public final Builder assessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
            return this;
        }

        public final void setAssessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
        }

        public final String getPreviewToken() {
            return previewToken;
        }

        @Override
        public final Builder previewToken(String previewToken) {
            this.previewToken = previewToken;
            return this;
        }

        public final void setPreviewToken(String previewToken) {
            this.previewToken = previewToken;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExclusionsPreviewRequest build() {
            return new GetExclusionsPreviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
