/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExclusionsPreviewResponse extends InspectorResponse implements
        ToCopyableBuilder<GetExclusionsPreviewResponse.Builder, GetExclusionsPreviewResponse> {
    private static final SdkField<String> PREVIEW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("previewStatus").getter(getter(GetExclusionsPreviewResponse::previewStatusAsString))
            .setter(setter(Builder::previewStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewStatus").build()).build();

    private static final SdkField<List<ExclusionPreview>> EXCLUSION_PREVIEWS_FIELD = SdkField
            .<List<ExclusionPreview>> builder(MarshallingType.LIST)
            .memberName("exclusionPreviews")
            .getter(getter(GetExclusionsPreviewResponse::exclusionPreviews))
            .setter(setter(Builder::exclusionPreviews))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionPreviews").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExclusionPreview> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExclusionPreview::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetExclusionsPreviewResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_STATUS_FIELD,
            EXCLUSION_PREVIEWS_FIELD, NEXT_TOKEN_FIELD));

    private final String previewStatus;

    private final List<ExclusionPreview> exclusionPreviews;

    private final String nextToken;

    private GetExclusionsPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.previewStatus = builder.previewStatus;
        this.exclusionPreviews = builder.exclusionPreviews;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specifies the status of the request to generate an exclusions preview.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #previewStatus}
     * will return {@link PreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #previewStatusAsString}.
     * </p>
     * 
     * @return Specifies the status of the request to generate an exclusions preview.
     * @see PreviewStatus
     */
    public final PreviewStatus previewStatus() {
        return PreviewStatus.fromValue(previewStatus);
    }

    /**
     * <p>
     * Specifies the status of the request to generate an exclusions preview.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #previewStatus}
     * will return {@link PreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #previewStatusAsString}.
     * </p>
     * 
     * @return Specifies the status of the request to generate an exclusions preview.
     * @see PreviewStatus
     */
    public final String previewStatusAsString() {
        return previewStatus;
    }

    /**
     * Returns true if the ExclusionPreviews property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExclusionPreviews() {
        return exclusionPreviews != null && !(exclusionPreviews instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the exclusions included in the preview.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExclusionPreviews()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the exclusions included in the preview.
     */
    public final List<ExclusionPreview> exclusionPreviews() {
        return exclusionPreviews;
    }

    /**
     * <p>
     * When a response is generated, if there is more data to be listed, this parameters is present in the response and
     * contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no more
     * data to be listed, this parameter is set to null.
     * </p>
     * 
     * @return When a response is generated, if there is more data to be listed, this parameters is present in the
     *         response and contains the value to use for the nextToken parameter in a subsequent pagination request. If
     *         there is no more data to be listed, this parameter is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(previewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionPreviews() ? exclusionPreviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExclusionsPreviewResponse)) {
            return false;
        }
        GetExclusionsPreviewResponse other = (GetExclusionsPreviewResponse) obj;
        return Objects.equals(previewStatusAsString(), other.previewStatusAsString())
                && hasExclusionPreviews() == other.hasExclusionPreviews()
                && Objects.equals(exclusionPreviews(), other.exclusionPreviews())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExclusionsPreviewResponse").add("PreviewStatus", previewStatusAsString())
                .add("ExclusionPreviews", hasExclusionPreviews() ? exclusionPreviews() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "previewStatus":
            return Optional.ofNullable(clazz.cast(previewStatusAsString()));
        case "exclusionPreviews":
            return Optional.ofNullable(clazz.cast(exclusionPreviews()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExclusionsPreviewResponse, T> g) {
        return obj -> g.apply((GetExclusionsPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExclusionsPreviewResponse> {
        /**
         * <p>
         * Specifies the status of the request to generate an exclusions preview.
         * </p>
         * 
         * @param previewStatus
         *        Specifies the status of the request to generate an exclusions preview.
         * @see PreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreviewStatus
         */
        Builder previewStatus(String previewStatus);

        /**
         * <p>
         * Specifies the status of the request to generate an exclusions preview.
         * </p>
         * 
         * @param previewStatus
         *        Specifies the status of the request to generate an exclusions preview.
         * @see PreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreviewStatus
         */
        Builder previewStatus(PreviewStatus previewStatus);

        /**
         * <p>
         * Information about the exclusions included in the preview.
         * </p>
         * 
         * @param exclusionPreviews
         *        Information about the exclusions included in the preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPreviews(Collection<ExclusionPreview> exclusionPreviews);

        /**
         * <p>
         * Information about the exclusions included in the preview.
         * </p>
         * 
         * @param exclusionPreviews
         *        Information about the exclusions included in the preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionPreviews(ExclusionPreview... exclusionPreviews);

        /**
         * <p>
         * Information about the exclusions included in the preview.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExclusionPreview>.Builder} avoiding the
         * need to create one manually via {@link List<ExclusionPreview>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExclusionPreview>.Builder#build()} is called immediately and
         * its result is passed to {@link #exclusionPreviews(List<ExclusionPreview>)}.
         * 
         * @param exclusionPreviews
         *        a consumer that will call methods on {@link List<ExclusionPreview>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclusionPreviews(List<ExclusionPreview>)
         */
        Builder exclusionPreviews(Consumer<ExclusionPreview.Builder>... exclusionPreviews);

        /**
         * <p>
         * When a response is generated, if there is more data to be listed, this parameters is present in the response
         * and contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no
         * more data to be listed, this parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        When a response is generated, if there is more data to be listed, this parameters is present in the
         *        response and contains the value to use for the nextToken parameter in a subsequent pagination request.
         *        If there is no more data to be listed, this parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private String previewStatus;

        private List<ExclusionPreview> exclusionPreviews = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExclusionsPreviewResponse model) {
            super(model);
            previewStatus(model.previewStatus);
            exclusionPreviews(model.exclusionPreviews);
            nextToken(model.nextToken);
        }

        public final String getPreviewStatus() {
            return previewStatus;
        }

        @Override
        public final Builder previewStatus(String previewStatus) {
            this.previewStatus = previewStatus;
            return this;
        }

        @Override
        public final Builder previewStatus(PreviewStatus previewStatus) {
            this.previewStatus(previewStatus == null ? null : previewStatus.toString());
            return this;
        }

        public final void setPreviewStatus(String previewStatus) {
            this.previewStatus = previewStatus;
        }

        public final List<ExclusionPreview.Builder> getExclusionPreviews() {
            List<ExclusionPreview.Builder> result = ExclusionPreviewListCopier.copyToBuilder(this.exclusionPreviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder exclusionPreviews(Collection<ExclusionPreview> exclusionPreviews) {
            this.exclusionPreviews = ExclusionPreviewListCopier.copy(exclusionPreviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPreviews(ExclusionPreview... exclusionPreviews) {
            exclusionPreviews(Arrays.asList(exclusionPreviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPreviews(Consumer<ExclusionPreview.Builder>... exclusionPreviews) {
            exclusionPreviews(Stream.of(exclusionPreviews).map(c -> ExclusionPreview.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExclusionPreviews(Collection<ExclusionPreview.BuilderImpl> exclusionPreviews) {
            this.exclusionPreviews = ExclusionPreviewListCopier.copyFromBuilder(exclusionPreviews);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetExclusionsPreviewResponse build() {
            return new GetExclusionsPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
