/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExclusionsResponse extends InspectorResponse implements
        ToCopyableBuilder<ListExclusionsResponse.Builder, ListExclusionsResponse> {
    private static final SdkField<List<String>> EXCLUSION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exclusionArns")
            .getter(getter(ListExclusionsResponse::exclusionArns))
            .setter(setter(Builder::exclusionArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListExclusionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSION_ARNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> exclusionArns;

    private final String nextToken;

    private ListExclusionsResponse(BuilderImpl builder) {
        super(builder);
        this.exclusionArns = builder.exclusionArns;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ExclusionArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasExclusionArns() {
        return exclusionArns != null && !(exclusionArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of exclusions' ARNs returned by the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExclusionArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of exclusions' ARNs returned by the action.
     */
    public final List<String> exclusionArns() {
        return exclusionArns;
    }

    /**
     * <p>
     * When a response is generated, if there is more data to be listed, this parameters is present in the response and
     * contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no more
     * data to be listed, this parameter is set to null.
     * </p>
     * 
     * @return When a response is generated, if there is more data to be listed, this parameters is present in the
     *         response and contains the value to use for the nextToken parameter in a subsequent pagination request. If
     *         there is no more data to be listed, this parameter is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionArns() ? exclusionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExclusionsResponse)) {
            return false;
        }
        ListExclusionsResponse other = (ListExclusionsResponse) obj;
        return hasExclusionArns() == other.hasExclusionArns() && Objects.equals(exclusionArns(), other.exclusionArns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExclusionsResponse").add("ExclusionArns", hasExclusionArns() ? exclusionArns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exclusionArns":
            return Optional.ofNullable(clazz.cast(exclusionArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExclusionsResponse, T> g) {
        return obj -> g.apply((ListExclusionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListExclusionsResponse> {
        /**
         * <p>
         * A list of exclusions' ARNs returned by the action.
         * </p>
         * 
         * @param exclusionArns
         *        A list of exclusions' ARNs returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionArns(Collection<String> exclusionArns);

        /**
         * <p>
         * A list of exclusions' ARNs returned by the action.
         * </p>
         * 
         * @param exclusionArns
         *        A list of exclusions' ARNs returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionArns(String... exclusionArns);

        /**
         * <p>
         * When a response is generated, if there is more data to be listed, this parameters is present in the response
         * and contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no
         * more data to be listed, this parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        When a response is generated, if there is more data to be listed, this parameters is present in the
         *        response and contains the value to use for the nextToken parameter in a subsequent pagination request.
         *        If there is no more data to be listed, this parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<String> exclusionArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExclusionsResponse model) {
            super(model);
            exclusionArns(model.exclusionArns);
            nextToken(model.nextToken);
        }

        public final Collection<String> getExclusionArns() {
            if (exclusionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionArns;
        }

        @Override
        public final Builder exclusionArns(Collection<String> exclusionArns) {
            this.exclusionArns = ListReturnedArnListCopier.copy(exclusionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionArns(String... exclusionArns) {
            exclusionArns(Arrays.asList(exclusionArns));
            return this;
        }

        public final void setExclusionArns(Collection<String> exclusionArns) {
            this.exclusionArns = ListReturnedArnListCopier.copy(exclusionArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExclusionsResponse build() {
            return new ListExclusionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
