/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AgentHealth;
import software.amazon.awssdk.services.inspector.model.AgentHealthCode;
import software.amazon.awssdk.services.inspector.model.AgentHealthCodeListCopier;
import software.amazon.awssdk.services.inspector.model.AgentHealthListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentFilter> {
    private static final SdkField<List<String>> AGENT_HEALTHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentHealths").getter(AgentFilter.getter(AgentFilter::agentHealthsAsStrings)).setter(AgentFilter.setter(Builder::agentHealthsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AGENT_HEALTH_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentHealthCodes").getter(AgentFilter.getter(AgentFilter::agentHealthCodesAsStrings)).setter(AgentFilter.setter(Builder::agentHealthCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealthCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_HEALTHS_FIELD, AGENT_HEALTH_CODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> agentHealths;
    private final List<String> agentHealthCodes;

    private AgentFilter(BuilderImpl builder) {
        this.agentHealths = builder.agentHealths;
        this.agentHealthCodes = builder.agentHealthCodes;
    }

    public final List<AgentHealth> agentHealths() {
        return AgentHealthListCopier.copyStringToEnum(this.agentHealths);
    }

    public final boolean hasAgentHealths() {
        return this.agentHealths != null && !(this.agentHealths instanceof SdkAutoConstructList);
    }

    public final List<String> agentHealthsAsStrings() {
        return this.agentHealths;
    }

    public final List<AgentHealthCode> agentHealthCodes() {
        return AgentHealthCodeListCopier.copyStringToEnum(this.agentHealthCodes);
    }

    public final boolean hasAgentHealthCodes() {
        return this.agentHealthCodes != null && !(this.agentHealthCodes instanceof SdkAutoConstructList);
    }

    public final List<String> agentHealthCodesAsStrings() {
        return this.agentHealthCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentHealths() ? this.agentHealthsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentHealthCodes() ? this.agentHealthCodesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentFilter)) {
            return false;
        }
        AgentFilter other = (AgentFilter)obj;
        return this.hasAgentHealths() == other.hasAgentHealths() && Objects.equals(this.agentHealthsAsStrings(), other.agentHealthsAsStrings()) && this.hasAgentHealthCodes() == other.hasAgentHealthCodes() && Objects.equals(this.agentHealthCodesAsStrings(), other.agentHealthCodesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AgentFilter").add("AgentHealths", this.hasAgentHealths() ? this.agentHealthsAsStrings() : null).add("AgentHealthCodes", this.hasAgentHealthCodes() ? this.agentHealthCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentHealths": {
                return Optional.ofNullable(clazz.cast(this.agentHealthsAsStrings()));
            }
            case "agentHealthCodes": {
                return Optional.ofNullable(clazz.cast(this.agentHealthCodesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentFilter, T> g) {
        return obj -> g.apply((AgentFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> agentHealths = DefaultSdkAutoConstructList.getInstance();
        private List<String> agentHealthCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentFilter model) {
            this.agentHealthsWithStrings(model.agentHealths);
            this.agentHealthCodesWithStrings(model.agentHealthCodes);
        }

        public final Collection<String> getAgentHealths() {
            if (this.agentHealths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentHealths;
        }

        public final void setAgentHealths(Collection<String> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copy(agentHealths);
        }

        @Override
        @Transient
        public final Builder agentHealthsWithStrings(Collection<String> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copy(agentHealths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealthsWithStrings(String ... agentHealths) {
            this.agentHealthsWithStrings(Arrays.asList(agentHealths));
            return this;
        }

        @Override
        @Transient
        public final Builder agentHealths(Collection<AgentHealth> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copyEnumToString(agentHealths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealths(AgentHealth ... agentHealths) {
            this.agentHealths(Arrays.asList(agentHealths));
            return this;
        }

        public final Collection<String> getAgentHealthCodes() {
            if (this.agentHealthCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentHealthCodes;
        }

        public final void setAgentHealthCodes(Collection<String> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copy(agentHealthCodes);
        }

        @Override
        @Transient
        public final Builder agentHealthCodesWithStrings(Collection<String> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copy(agentHealthCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealthCodesWithStrings(String ... agentHealthCodes) {
            this.agentHealthCodesWithStrings(Arrays.asList(agentHealthCodes));
            return this;
        }

        @Override
        @Transient
        public final Builder agentHealthCodes(Collection<AgentHealthCode> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copyEnumToString(agentHealthCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealthCodes(AgentHealthCode ... agentHealthCodes) {
            this.agentHealthCodes(Arrays.asList(agentHealthCodes));
            return this;
        }

        public AgentFilter build() {
            return new AgentFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentFilter> {
        public Builder agentHealthsWithStrings(Collection<String> var1);

        public Builder agentHealthsWithStrings(String ... var1);

        public Builder agentHealths(Collection<AgentHealth> var1);

        public Builder agentHealths(AgentHealth ... var1);

        public Builder agentHealthCodesWithStrings(Collection<String> var1);

        public Builder agentHealthCodesWithStrings(String ... var1);

        public Builder agentHealthCodes(Collection<AgentHealthCode> var1);

        public Builder agentHealthCodes(AgentHealthCode ... var1);
    }
}

