/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AgentAlreadyRunningAssessment;
import software.amazon.awssdk.services.inspector.model.AgentAlreadyRunningAssessmentListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentsAlreadyRunningAssessmentException
extends InspectorException
implements ToCopyableBuilder<Builder, AgentsAlreadyRunningAssessmentException> {
    private static final SdkField<List<AgentAlreadyRunningAssessment>> AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agents").getter(AgentsAlreadyRunningAssessmentException.getter(AgentsAlreadyRunningAssessmentException::agents)).setter(AgentsAlreadyRunningAssessmentException.setter(Builder::agents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentAlreadyRunningAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AGENTS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("agentsTruncated").getter(AgentsAlreadyRunningAssessmentException.getter(AgentsAlreadyRunningAssessmentException::agentsTruncated)).setter(AgentsAlreadyRunningAssessmentException.setter(Builder::agentsTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentsTruncated").build()}).build();
    private static final SdkField<Boolean> CAN_RETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canRetry").getter(AgentsAlreadyRunningAssessmentException.getter(AgentsAlreadyRunningAssessmentException::canRetry)).setter(AgentsAlreadyRunningAssessmentException.setter(Builder::canRetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canRetry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENTS_FIELD, AGENTS_TRUNCATED_FIELD, CAN_RETRY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AgentAlreadyRunningAssessment> agents;
    private final Boolean agentsTruncated;
    private final Boolean canRetry;

    private AgentsAlreadyRunningAssessmentException(BuilderImpl builder) {
        super(builder);
        this.agents = builder.agents;
        this.agentsTruncated = builder.agentsTruncated;
        this.canRetry = builder.canRetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasAgents() {
        return this.agents != null && !(this.agents instanceof SdkAutoConstructList);
    }

    public List<AgentAlreadyRunningAssessment> agents() {
        return this.agents;
    }

    public Boolean agentsTruncated() {
        return this.agentsTruncated;
    }

    public Boolean canRetry() {
        return this.canRetry;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentsAlreadyRunningAssessmentException, T> g) {
        return obj -> g.apply((AgentsAlreadyRunningAssessmentException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorException.BuilderImpl
    implements Builder {
        private List<AgentAlreadyRunningAssessment> agents = DefaultSdkAutoConstructList.getInstance();
        private Boolean agentsTruncated;
        private Boolean canRetry;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentsAlreadyRunningAssessmentException model) {
            super(model);
            this.agents(model.agents);
            this.agentsTruncated(model.agentsTruncated);
            this.canRetry(model.canRetry);
        }

        public final List<AgentAlreadyRunningAssessment.Builder> getAgents() {
            List<AgentAlreadyRunningAssessment.Builder> result = AgentAlreadyRunningAssessmentListCopier.copyToBuilder(this.agents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgents(Collection<AgentAlreadyRunningAssessment.BuilderImpl> agents) {
            this.agents = AgentAlreadyRunningAssessmentListCopier.copyFromBuilder(agents);
        }

        @Override
        @Transient
        public final Builder agents(Collection<AgentAlreadyRunningAssessment> agents) {
            this.agents = AgentAlreadyRunningAssessmentListCopier.copy(agents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agents(AgentAlreadyRunningAssessment ... agents) {
            this.agents(Arrays.asList(agents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agents(Consumer<AgentAlreadyRunningAssessment.Builder> ... agents) {
            this.agents(Stream.of(agents).map(c -> (AgentAlreadyRunningAssessment)((AgentAlreadyRunningAssessment.Builder)AgentAlreadyRunningAssessment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAgentsTruncated() {
            return this.agentsTruncated;
        }

        public final void setAgentsTruncated(Boolean agentsTruncated) {
            this.agentsTruncated = agentsTruncated;
        }

        @Override
        @Transient
        public final Builder agentsTruncated(Boolean agentsTruncated) {
            this.agentsTruncated = agentsTruncated;
            return this;
        }

        public final Boolean getCanRetry() {
            return this.canRetry;
        }

        public final void setCanRetry(Boolean canRetry) {
            this.canRetry = canRetry;
        }

        @Override
        @Transient
        public final Builder canRetry(Boolean canRetry) {
            this.canRetry = canRetry;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public AgentsAlreadyRunningAssessmentException build() {
            return new AgentsAlreadyRunningAssessmentException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentsAlreadyRunningAssessmentException>,
    InspectorException.Builder {
        public Builder agents(Collection<AgentAlreadyRunningAssessment> var1);

        public Builder agents(AgentAlreadyRunningAssessment ... var1);

        public Builder agents(Consumer<AgentAlreadyRunningAssessment.Builder> ... var1);

        public Builder agentsTruncated(Boolean var1);

        public Builder canRetry(Boolean var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

