/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventSubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventSubscription> {
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(EventSubscription.getter(EventSubscription::eventAsString)).setter(EventSubscription.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<Instant> SUBSCRIBED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("subscribedAt").getter(EventSubscription.getter(EventSubscription::subscribedAt)).setter(EventSubscription.setter(Builder::subscribedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, SUBSCRIBED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String event;
    private final Instant subscribedAt;

    private EventSubscription(BuilderImpl builder) {
        this.event = builder.event;
        this.subscribedAt = builder.subscribedAt;
    }

    public final InspectorEvent event() {
        return InspectorEvent.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public final Instant subscribedAt() {
        return this.subscribedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription)obj;
        return Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.subscribedAt(), other.subscribedAt());
    }

    public final String toString() {
        return ToString.builder((String)"EventSubscription").add("Event", (Object)this.eventAsString()).add("SubscribedAt", (Object)this.subscribedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "subscribedAt": {
                return Optional.ofNullable(clazz.cast(this.subscribedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSubscription, T> g) {
        return obj -> g.apply((EventSubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String event;
        private Instant subscribedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            this.event(model.event);
            this.subscribedAt(model.subscribedAt);
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        @Transient
        public final Builder event(InspectorEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final Instant getSubscribedAt() {
            return this.subscribedAt;
        }

        public final void setSubscribedAt(Instant subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        @Transient
        public final Builder subscribedAt(Instant subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        public EventSubscription build() {
            return new EventSubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventSubscription> {
        public Builder event(String var1);

        public Builder event(InspectorEvent var1);

        public Builder subscribedAt(Instant var1);
    }
}

