/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.services.inspector.model.Locale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExclusionsPreviewRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, GetExclusionsPreviewRequest> {
    private static final SdkField<String> ASSESSMENT_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentTemplateArn").getter(GetExclusionsPreviewRequest.getter(GetExclusionsPreviewRequest::assessmentTemplateArn)).setter(GetExclusionsPreviewRequest.setter(Builder::assessmentTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArn").build()}).build();
    private static final SdkField<String> PREVIEW_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("previewToken").getter(GetExclusionsPreviewRequest.getter(GetExclusionsPreviewRequest::previewToken)).setter(GetExclusionsPreviewRequest.setter(Builder::previewToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewToken").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetExclusionsPreviewRequest.getter(GetExclusionsPreviewRequest::nextToken)).setter(GetExclusionsPreviewRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetExclusionsPreviewRequest.getter(GetExclusionsPreviewRequest::maxResults)).setter(GetExclusionsPreviewRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(GetExclusionsPreviewRequest.getter(GetExclusionsPreviewRequest::localeAsString)).setter(GetExclusionsPreviewRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TEMPLATE_ARN_FIELD, PREVIEW_TOKEN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LOCALE_FIELD));
    private final String assessmentTemplateArn;
    private final String previewToken;
    private final String nextToken;
    private final Integer maxResults;
    private final String locale;

    private GetExclusionsPreviewRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplateArn = builder.assessmentTemplateArn;
        this.previewToken = builder.previewToken;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.locale = builder.locale;
    }

    public final String assessmentTemplateArn() {
        return this.assessmentTemplateArn;
    }

    public final String previewToken() {
        return this.previewToken;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.previewToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExclusionsPreviewRequest)) {
            return false;
        }
        GetExclusionsPreviewRequest other = (GetExclusionsPreviewRequest)((Object)obj);
        return Objects.equals(this.assessmentTemplateArn(), other.assessmentTemplateArn()) && Objects.equals(this.previewToken(), other.previewToken()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.localeAsString(), other.localeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetExclusionsPreviewRequest").add("AssessmentTemplateArn", (Object)this.assessmentTemplateArn()).add("PreviewToken", (Object)this.previewToken()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Locale", (Object)this.localeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentTemplateArn()));
            }
            case "previewToken": {
                return Optional.ofNullable(clazz.cast(this.previewToken()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExclusionsPreviewRequest, T> g) {
        return obj -> g.apply((GetExclusionsPreviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private String assessmentTemplateArn;
        private String previewToken;
        private String nextToken;
        private Integer maxResults;
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExclusionsPreviewRequest model) {
            super(model);
            this.assessmentTemplateArn(model.assessmentTemplateArn);
            this.previewToken(model.previewToken);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.locale(model.locale);
        }

        public final String getAssessmentTemplateArn() {
            return this.assessmentTemplateArn;
        }

        public final void setAssessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
        }

        @Override
        @Transient
        public final Builder assessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
            return this;
        }

        public final String getPreviewToken() {
            return this.previewToken;
        }

        public final void setPreviewToken(String previewToken) {
            this.previewToken = previewToken;
        }

        @Override
        @Transient
        public final Builder previewToken(String previewToken) {
            this.previewToken = previewToken;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        @Transient
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        @Transient
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExclusionsPreviewRequest build() {
            return new GetExclusionsPreviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExclusionsPreviewRequest> {
        public Builder assessmentTemplateArn(String var1);

        public Builder previewToken(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

