/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.ListReturnedArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentRunsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, ListAssessmentRunsResponse> {
    private static final SdkField<List<String>> ASSESSMENT_RUN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentRunArns").getter(ListAssessmentRunsResponse.getter(ListAssessmentRunsResponse::assessmentRunArns)).setter(ListAssessmentRunsResponse.setter(Builder::assessmentRunArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentRunsResponse.getter(ListAssessmentRunsResponse::nextToken)).setter(ListAssessmentRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> assessmentRunArns;
    private final String nextToken;

    private ListAssessmentRunsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArns = builder.assessmentRunArns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessmentRunArns() {
        return this.assessmentRunArns != null && !(this.assessmentRunArns instanceof SdkAutoConstructList);
    }

    public final List<String> assessmentRunArns() {
        return this.assessmentRunArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentRunArns() ? this.assessmentRunArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentRunsResponse)) {
            return false;
        }
        ListAssessmentRunsResponse other = (ListAssessmentRunsResponse)((Object)obj);
        return this.hasAssessmentRunArns() == other.hasAssessmentRunArns() && Objects.equals(this.assessmentRunArns(), other.assessmentRunArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssessmentRunsResponse").add("AssessmentRunArns", this.hasAssessmentRunArns() ? this.assessmentRunArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentRunArns": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentRunsResponse, T> g) {
        return obj -> g.apply((ListAssessmentRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<String> assessmentRunArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentRunsResponse model) {
            super(model);
            this.assessmentRunArns(model.assessmentRunArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAssessmentRunArns() {
            if (this.assessmentRunArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentRunArns;
        }

        public final void setAssessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = ListReturnedArnListCopier.copy(assessmentRunArns);
        }

        @Override
        @Transient
        public final Builder assessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = ListReturnedArnListCopier.copy(assessmentRunArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assessmentRunArns(String ... assessmentRunArns) {
            this.assessmentRunArns(Arrays.asList(assessmentRunArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentRunsResponse build() {
            return new ListAssessmentRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentRunsResponse> {
        public Builder assessmentRunArns(Collection<String> var1);

        public Builder assessmentRunArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

