/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You started an assessment run, but one of the instances is already participating in another assessment run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentsAlreadyRunningAssessmentException extends InspectorException implements
        ToCopyableBuilder<AgentsAlreadyRunningAssessmentException.Builder, AgentsAlreadyRunningAssessmentException> {
    private static final SdkField<List<AgentAlreadyRunningAssessment>> AGENTS_FIELD = SdkField
            .<List<AgentAlreadyRunningAssessment>> builder(MarshallingType.LIST)
            .memberName("agents")
            .getter(getter(AgentsAlreadyRunningAssessmentException::agents))
            .setter(setter(Builder::agents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentAlreadyRunningAssessment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentAlreadyRunningAssessment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AGENTS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("agentsTruncated").getter(getter(AgentsAlreadyRunningAssessmentException::agentsTruncated))
            .setter(setter(Builder::agentsTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentsTruncated").build()).build();

    private static final SdkField<Boolean> CAN_RETRY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canRetry").getter(getter(AgentsAlreadyRunningAssessmentException::canRetry))
            .setter(setter(Builder::canRetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canRetry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENTS_FIELD,
            AGENTS_TRUNCATED_FIELD, CAN_RETRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AgentAlreadyRunningAssessment> agents;

    private final Boolean agentsTruncated;

    private final Boolean canRetry;

    private AgentsAlreadyRunningAssessmentException(BuilderImpl builder) {
        super(builder);
        this.agents = builder.agents;
        this.agentsTruncated = builder.agentsTruncated;
        this.canRetry = builder.canRetry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the Agents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public boolean hasAgents() {
        return agents != null && !(agents instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgents} method.
     * </p>
     * 
     * @return
     */
    public List<AgentAlreadyRunningAssessment> agents() {
        return agents;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Boolean agentsTruncated() {
        return agentsTruncated;
    }

    /**
     * <p>
     * You can immediately retry your request.
     * </p>
     * 
     * @return You can immediately retry your request.
     */
    public Boolean canRetry() {
        return canRetry;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentsAlreadyRunningAssessmentException, T> g) {
        return obj -> g.apply((AgentsAlreadyRunningAssessmentException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentsAlreadyRunningAssessmentException>,
            InspectorException.Builder {
        /**
         * <p/>
         * 
         * @param agents
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(Collection<AgentAlreadyRunningAssessment> agents);

        /**
         * <p/>
         * 
         * @param agents
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(AgentAlreadyRunningAssessment... agents);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<AgentAlreadyRunningAssessment>.Builder}
         * avoiding the need to create one manually via {@link List<AgentAlreadyRunningAssessment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AgentAlreadyRunningAssessment>.Builder#build()} is called
         * immediately and its result is passed to {@link #agents(List<AgentAlreadyRunningAssessment>)}.
         * 
         * @param agents
         *        a consumer that will call methods on {@link List<AgentAlreadyRunningAssessment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agents(List<AgentAlreadyRunningAssessment>)
         */
        Builder agents(Consumer<AgentAlreadyRunningAssessment.Builder>... agents);

        /**
         * <p/>
         * 
         * @param agentsTruncated
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentsTruncated(Boolean agentsTruncated);

        /**
         * <p>
         * You can immediately retry your request.
         * </p>
         * 
         * @param canRetry
         *        You can immediately retry your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canRetry(Boolean canRetry);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends InspectorException.BuilderImpl implements Builder {
        private List<AgentAlreadyRunningAssessment> agents = DefaultSdkAutoConstructList.getInstance();

        private Boolean agentsTruncated;

        private Boolean canRetry;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentsAlreadyRunningAssessmentException model) {
            super(model);
            agents(model.agents);
            agentsTruncated(model.agentsTruncated);
            canRetry(model.canRetry);
        }

        public final List<AgentAlreadyRunningAssessment.Builder> getAgents() {
            List<AgentAlreadyRunningAssessment.Builder> result = AgentAlreadyRunningAssessmentListCopier
                    .copyToBuilder(this.agents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgents(Collection<AgentAlreadyRunningAssessment.BuilderImpl> agents) {
            this.agents = AgentAlreadyRunningAssessmentListCopier.copyFromBuilder(agents);
        }

        @Override
        @Transient
        public final Builder agents(Collection<AgentAlreadyRunningAssessment> agents) {
            this.agents = AgentAlreadyRunningAssessmentListCopier.copy(agents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agents(AgentAlreadyRunningAssessment... agents) {
            agents(Arrays.asList(agents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agents(Consumer<AgentAlreadyRunningAssessment.Builder>... agents) {
            agents(Stream.of(agents).map(c -> AgentAlreadyRunningAssessment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAgentsTruncated() {
            return agentsTruncated;
        }

        public final void setAgentsTruncated(Boolean agentsTruncated) {
            this.agentsTruncated = agentsTruncated;
        }

        @Override
        @Transient
        public final Builder agentsTruncated(Boolean agentsTruncated) {
            this.agentsTruncated = agentsTruncated;
            return this;
        }

        public final Boolean getCanRetry() {
            return canRetry;
        }

        public final void setCanRetry(Boolean canRetry) {
            this.canRetry = canRetry;
        }

        @Override
        @Transient
        public final Builder canRetry(Boolean canRetry) {
            this.canRetry = canRetry;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public AgentsAlreadyRunningAssessmentException build() {
            return new AgentsAlreadyRunningAssessmentException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
