/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.AssessmentRunNotificationSnsStatusCode;
import software.amazon.awssdk.services.inspector.model.InspectorEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentRunNotification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentRunNotification> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("date").getter(AssessmentRunNotification.getter(AssessmentRunNotification::date)).setter(AssessmentRunNotification.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(AssessmentRunNotification.getter(AssessmentRunNotification::eventAsString)).setter(AssessmentRunNotification.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AssessmentRunNotification.getter(AssessmentRunNotification::message)).setter(AssessmentRunNotification.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Boolean> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("error").getter(AssessmentRunNotification.getter(AssessmentRunNotification::error)).setter(AssessmentRunNotification.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsTopicArn").getter(AssessmentRunNotification.getter(AssessmentRunNotification::snsTopicArn)).setter(AssessmentRunNotification.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopicArn").build()}).build();
    private static final SdkField<String> SNS_PUBLISH_STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snsPublishStatusCode").getter(AssessmentRunNotification.getter(AssessmentRunNotification::snsPublishStatusCodeAsString)).setter(AssessmentRunNotification.setter(Builder::snsPublishStatusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsPublishStatusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, EVENT_FIELD, MESSAGE_FIELD, ERROR_FIELD, SNS_TOPIC_ARN_FIELD, SNS_PUBLISH_STATUS_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant date;
    private final String event;
    private final String message;
    private final Boolean error;
    private final String snsTopicArn;
    private final String snsPublishStatusCode;

    private AssessmentRunNotification(BuilderImpl builder) {
        this.date = builder.date;
        this.event = builder.event;
        this.message = builder.message;
        this.error = builder.error;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsPublishStatusCode = builder.snsPublishStatusCode;
    }

    public final Instant date() {
        return this.date;
    }

    public final InspectorEvent event() {
        return InspectorEvent.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public final String message() {
        return this.message;
    }

    public final Boolean error() {
        return this.error;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final AssessmentRunNotificationSnsStatusCode snsPublishStatusCode() {
        return AssessmentRunNotificationSnsStatusCode.fromValue(this.snsPublishStatusCode);
    }

    public final String snsPublishStatusCodeAsString() {
        return this.snsPublishStatusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsPublishStatusCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunNotification)) {
            return false;
        }
        AssessmentRunNotification other = (AssessmentRunNotification)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.snsPublishStatusCodeAsString(), other.snsPublishStatusCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentRunNotification").add("Date", (Object)this.date()).add("Event", (Object)this.eventAsString()).add("Message", (Object)this.message()).add("Error", (Object)this.error()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SnsPublishStatusCode", (Object)this.snsPublishStatusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "snsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "snsPublishStatusCode": {
                return Optional.ofNullable(clazz.cast(this.snsPublishStatusCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunNotification, T> g) {
        return obj -> g.apply((AssessmentRunNotification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant date;
        private String event;
        private String message;
        private Boolean error;
        private String snsTopicArn;
        private String snsPublishStatusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunNotification model) {
            this.date(model.date);
            this.event(model.event);
            this.message(model.message);
            this.error(model.error);
            this.snsTopicArn(model.snsTopicArn);
            this.snsPublishStatusCode(model.snsPublishStatusCode);
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        @Transient
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        @Transient
        public final Builder event(InspectorEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Boolean getError() {
            return this.error;
        }

        public final void setError(Boolean error) {
            this.error = error;
        }

        @Override
        @Transient
        public final Builder error(Boolean error) {
            this.error = error;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        @Transient
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsPublishStatusCode() {
            return this.snsPublishStatusCode;
        }

        public final void setSnsPublishStatusCode(String snsPublishStatusCode) {
            this.snsPublishStatusCode = snsPublishStatusCode;
        }

        @Override
        @Transient
        public final Builder snsPublishStatusCode(String snsPublishStatusCode) {
            this.snsPublishStatusCode = snsPublishStatusCode;
            return this;
        }

        @Override
        @Transient
        public final Builder snsPublishStatusCode(AssessmentRunNotificationSnsStatusCode snsPublishStatusCode) {
            this.snsPublishStatusCode(snsPublishStatusCode == null ? null : snsPublishStatusCode.toString());
            return this;
        }

        public AssessmentRunNotification build() {
            return new AssessmentRunNotification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentRunNotification> {
        public Builder date(Instant var1);

        public Builder event(String var1);

        public Builder event(InspectorEvent var1);

        public Builder message(String var1);

        public Builder error(Boolean var1);

        public Builder snsTopicArn(String var1);

        public Builder snsPublishStatusCode(String var1);

        public Builder snsPublishStatusCode(AssessmentRunNotificationSnsStatusCode var1);
    }
}

