/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request was rejected because it referenced an entity that does not exist. The error code describes the entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NoSuchEntityException extends InspectorException implements
        ToCopyableBuilder<NoSuchEntityException.Builder, NoSuchEntityException> {
    private static final SdkField<Boolean> CAN_RETRY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("canRetry").getter(getter(NoSuchEntityException::canRetry)).setter(setter(Builder::canRetry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canRetry").build()).build();

    private static final SdkField<String> INSPECTOR_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inspectorErrorCode").getter(getter(NoSuchEntityException::inspectorErrorCodeAsString))
            .setter(setter(Builder::inspectorErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_RETRY_FIELD,
            INSPECTOR_ERROR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean canRetry;

    private final String inspectorErrorCode;

    private NoSuchEntityException(BuilderImpl builder) {
        super(builder);
        this.canRetry = builder.canRetry;
        this.inspectorErrorCode = builder.inspectorErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * You can immediately retry your request.
     * </p>
     * 
     * @return You can immediately retry your request.
     */
    public Boolean canRetry() {
        return canRetry;
    }

    /**
     * <p>
     * Code that indicates the type of error that is generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inspectorErrorCode} will return {@link NoSuchEntityErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inspectorErrorCodeAsString}.
     * </p>
     * 
     * @return Code that indicates the type of error that is generated.
     * @see NoSuchEntityErrorCode
     */
    public NoSuchEntityErrorCode inspectorErrorCode() {
        return NoSuchEntityErrorCode.fromValue(inspectorErrorCode);
    }

    /**
     * <p>
     * Code that indicates the type of error that is generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inspectorErrorCode} will return {@link NoSuchEntityErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inspectorErrorCodeAsString}.
     * </p>
     * 
     * @return Code that indicates the type of error that is generated.
     * @see NoSuchEntityErrorCode
     */
    public String inspectorErrorCodeAsString() {
        return inspectorErrorCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NoSuchEntityException, T> g) {
        return obj -> g.apply((NoSuchEntityException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NoSuchEntityException>, InspectorException.Builder {
        /**
         * <p>
         * You can immediately retry your request.
         * </p>
         * 
         * @param canRetry
         *        You can immediately retry your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canRetry(Boolean canRetry);

        /**
         * <p>
         * Code that indicates the type of error that is generated.
         * </p>
         * 
         * @param inspectorErrorCode
         *        Code that indicates the type of error that is generated.
         * @see NoSuchEntityErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoSuchEntityErrorCode
         */
        Builder inspectorErrorCode(String inspectorErrorCode);

        /**
         * <p>
         * Code that indicates the type of error that is generated.
         * </p>
         * 
         * @param inspectorErrorCode
         *        Code that indicates the type of error that is generated.
         * @see NoSuchEntityErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NoSuchEntityErrorCode
         */
        Builder inspectorErrorCode(NoSuchEntityErrorCode inspectorErrorCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends InspectorException.BuilderImpl implements Builder {
        private Boolean canRetry;

        private String inspectorErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(NoSuchEntityException model) {
            super(model);
            canRetry(model.canRetry);
            inspectorErrorCode(model.inspectorErrorCode);
        }

        public final Boolean getCanRetry() {
            return canRetry;
        }

        public final void setCanRetry(Boolean canRetry) {
            this.canRetry = canRetry;
        }

        @Override
        public final Builder canRetry(Boolean canRetry) {
            this.canRetry = canRetry;
            return this;
        }

        public final String getInspectorErrorCode() {
            return inspectorErrorCode;
        }

        public final void setInspectorErrorCode(String inspectorErrorCode) {
            this.inspectorErrorCode = inspectorErrorCode;
        }

        @Override
        public final Builder inspectorErrorCode(String inspectorErrorCode) {
            this.inspectorErrorCode = inspectorErrorCode;
            return this;
        }

        @Override
        public final Builder inspectorErrorCode(NoSuchEntityErrorCode inspectorErrorCode) {
            this.inspectorErrorCode(inspectorErrorCode == null ? null : inspectorErrorCode.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public NoSuchEntityException build() {
            return new NoSuchEntityException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
