/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTelemetryMetadataResponse extends InspectorResponse implements
        ToCopyableBuilder<GetTelemetryMetadataResponse.Builder, GetTelemetryMetadataResponse> {
    private static final SdkField<List<TelemetryMetadata>> TELEMETRY_METADATA_FIELD = SdkField
            .<List<TelemetryMetadata>> builder(MarshallingType.LIST)
            .memberName("telemetryMetadata")
            .getter(getter(GetTelemetryMetadataResponse::telemetryMetadata))
            .setter(setter(Builder::telemetryMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telemetryMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TelemetryMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(TelemetryMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEMETRY_METADATA_FIELD));

    private final List<TelemetryMetadata> telemetryMetadata;

    private GetTelemetryMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.telemetryMetadata = builder.telemetryMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the TelemetryMetadata property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTelemetryMetadata() {
        return telemetryMetadata != null && !(telemetryMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Telemetry details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTelemetryMetadata} method.
     * </p>
     * 
     * @return Telemetry details.
     */
    public final List<TelemetryMetadata> telemetryMetadata() {
        return telemetryMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTelemetryMetadata() ? telemetryMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTelemetryMetadataResponse)) {
            return false;
        }
        GetTelemetryMetadataResponse other = (GetTelemetryMetadataResponse) obj;
        return hasTelemetryMetadata() == other.hasTelemetryMetadata()
                && Objects.equals(telemetryMetadata(), other.telemetryMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTelemetryMetadataResponse")
                .add("TelemetryMetadata", hasTelemetryMetadata() ? telemetryMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "telemetryMetadata":
            return Optional.ofNullable(clazz.cast(telemetryMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTelemetryMetadataResponse, T> g) {
        return obj -> g.apply((GetTelemetryMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTelemetryMetadataResponse> {
        /**
         * <p>
         * Telemetry details.
         * </p>
         * 
         * @param telemetryMetadata
         *        Telemetry details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryMetadata(Collection<TelemetryMetadata> telemetryMetadata);

        /**
         * <p>
         * Telemetry details.
         * </p>
         * 
         * @param telemetryMetadata
         *        Telemetry details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryMetadata(TelemetryMetadata... telemetryMetadata);

        /**
         * <p>
         * Telemetry details.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TelemetryMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<TelemetryMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TelemetryMetadata>.Builder#build()} is called immediately
         * and its result is passed to {@link #telemetryMetadata(List<TelemetryMetadata>)}.
         * 
         * @param telemetryMetadata
         *        a consumer that will call methods on {@link List<TelemetryMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryMetadata(List<TelemetryMetadata>)
         */
        Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder>... telemetryMetadata);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<TelemetryMetadata> telemetryMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTelemetryMetadataResponse model) {
            super(model);
            telemetryMetadata(model.telemetryMetadata);
        }

        public final List<TelemetryMetadata.Builder> getTelemetryMetadata() {
            List<TelemetryMetadata.Builder> result = TelemetryMetadataListCopier.copyToBuilder(this.telemetryMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTelemetryMetadata(Collection<TelemetryMetadata.BuilderImpl> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copyFromBuilder(telemetryMetadata);
        }

        @Override
        public final Builder telemetryMetadata(Collection<TelemetryMetadata> telemetryMetadata) {
            this.telemetryMetadata = TelemetryMetadataListCopier.copy(telemetryMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(TelemetryMetadata... telemetryMetadata) {
            telemetryMetadata(Arrays.asList(telemetryMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryMetadata(Consumer<TelemetryMetadata.Builder>... telemetryMetadata) {
            telemetryMetadata(Stream.of(telemetryMetadata).map(c -> TelemetryMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTelemetryMetadataResponse build() {
            return new GetTelemetryMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
