/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse;

public class PreviewAgentsIterable
implements SdkIterable<PreviewAgentsResponse> {
    private final InspectorClient client;
    private final PreviewAgentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public PreviewAgentsIterable(InspectorClient client, PreviewAgentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new PreviewAgentsResponseFetcher();
    }

    public Iterator<PreviewAgentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class PreviewAgentsResponseFetcher
    implements SyncPageFetcher<PreviewAgentsResponse> {
        private PreviewAgentsResponseFetcher() {
        }

        public boolean hasNextPage(PreviewAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public PreviewAgentsResponse nextPage(PreviewAgentsResponse previousPage) {
            if (previousPage == null) {
                return PreviewAgentsIterable.this.client.previewAgents(PreviewAgentsIterable.this.firstRequest);
            }
            return PreviewAgentsIterable.this.client.previewAgents((PreviewAgentsRequest)((Object)PreviewAgentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

