/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorEvent;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnsubscribeFromEventRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, UnsubscribeFromEventRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(UnsubscribeFromEventRequest.getter(UnsubscribeFromEventRequest::resourceArn)).setter(UnsubscribeFromEventRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(UnsubscribeFromEventRequest.getter(UnsubscribeFromEventRequest::eventAsString)).setter(UnsubscribeFromEventRequest.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topicArn").getter(UnsubscribeFromEventRequest.getter(UnsubscribeFromEventRequest::topicArn)).setter(UnsubscribeFromEventRequest.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, EVENT_FIELD, TOPIC_ARN_FIELD));
    private final String resourceArn;
    private final String event;
    private final String topicArn;

    private UnsubscribeFromEventRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.event = builder.event;
        this.topicArn = builder.topicArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final InspectorEvent event() {
        return InspectorEvent.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsubscribeFromEventRequest)) {
            return false;
        }
        UnsubscribeFromEventRequest other = (UnsubscribeFromEventRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.topicArn(), other.topicArn());
    }

    public final String toString() {
        return ToString.builder((String)"UnsubscribeFromEventRequest").add("ResourceArn", (Object)this.resourceArn()).add("Event", (Object)this.eventAsString()).add("TopicArn", (Object)this.topicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "topicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnsubscribeFromEventRequest, T> g) {
        return obj -> g.apply((UnsubscribeFromEventRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String event;
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsubscribeFromEventRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.event(model.event);
            this.topicArn(model.topicArn);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        @Transient
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        @Transient
        public final Builder event(InspectorEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        @Transient
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnsubscribeFromEventRequest build() {
            return new UnsubscribeFromEventRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UnsubscribeFromEventRequest> {
        public Builder resourceArn(String var1);

        public Builder event(String var1);

        public Builder event(InspectorEvent var1);

        public Builder topicArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

