/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an Amazon Inspector agent. This data type is used as a request parameter in the
 * <a>ListAssessmentRunAgents</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentFilter implements SdkPojo, Serializable, ToCopyableBuilder<AgentFilter.Builder, AgentFilter> {
    private static final SdkField<List<String>> AGENT_HEALTHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("agentHealths")
            .getter(getter(AgentFilter::agentHealthsAsStrings))
            .setter(setter(Builder::agentHealthsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AGENT_HEALTH_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("agentHealthCodes")
            .getter(getter(AgentFilter::agentHealthCodesAsStrings))
            .setter(setter(Builder::agentHealthCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealthCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_HEALTHS_FIELD,
            AGENT_HEALTH_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> agentHealths;

    private final List<String> agentHealthCodes;

    private AgentFilter(BuilderImpl builder) {
        this.agentHealths = builder.agentHealths;
        this.agentHealthCodes = builder.agentHealthCodes;
    }

    /**
     * <p>
     * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentHealths} method.
     * </p>
     * 
     * @return The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     */
    public final List<AgentHealth> agentHealths() {
        return AgentHealthListCopier.copyStringToEnum(agentHealths);
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentHealths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentHealths() {
        return agentHealths != null && !(agentHealths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentHealths} method.
     * </p>
     * 
     * @return The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     */
    public final List<String> agentHealthsAsStrings() {
        return agentHealths;
    }

    /**
     * <p>
     * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
     * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentHealthCodes} method.
     * </p>
     * 
     * @return The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
     *         <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     */
    public final List<AgentHealthCode> agentHealthCodes() {
        return AgentHealthCodeListCopier.copyStringToEnum(agentHealthCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentHealthCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentHealthCodes() {
        return agentHealthCodes != null && !(agentHealthCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
     * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentHealthCodes} method.
     * </p>
     * 
     * @return The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
     *         <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     */
    public final List<String> agentHealthCodesAsStrings() {
        return agentHealthCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentHealths() ? agentHealthsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentHealthCodes() ? agentHealthCodesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentFilter)) {
            return false;
        }
        AgentFilter other = (AgentFilter) obj;
        return hasAgentHealths() == other.hasAgentHealths()
                && Objects.equals(agentHealthsAsStrings(), other.agentHealthsAsStrings())
                && hasAgentHealthCodes() == other.hasAgentHealthCodes()
                && Objects.equals(agentHealthCodesAsStrings(), other.agentHealthCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentFilter").add("AgentHealths", hasAgentHealths() ? agentHealthsAsStrings() : null)
                .add("AgentHealthCodes", hasAgentHealthCodes() ? agentHealthCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentHealths":
            return Optional.ofNullable(clazz.cast(agentHealthsAsStrings()));
        case "agentHealthCodes":
            return Optional.ofNullable(clazz.cast(agentHealthCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentFilter, T> g) {
        return obj -> g.apply((AgentFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentFilter> {
        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthsWithStrings(Collection<String> agentHealths);

        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthsWithStrings(String... agentHealths);

        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealths(Collection<AgentHealth> agentHealths);

        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealths(AgentHealth... agentHealths);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodesWithStrings(Collection<String> agentHealthCodes);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodesWithStrings(String... agentHealthCodes);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodes(Collection<AgentHealthCode> agentHealthCodes);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodes(AgentHealthCode... agentHealthCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> agentHealths = DefaultSdkAutoConstructList.getInstance();

        private List<String> agentHealthCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentFilter model) {
            agentHealthsWithStrings(model.agentHealths);
            agentHealthCodesWithStrings(model.agentHealthCodes);
        }

        public final Collection<String> getAgentHealths() {
            if (agentHealths instanceof SdkAutoConstructList) {
                return null;
            }
            return agentHealths;
        }

        public final void setAgentHealths(Collection<String> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copy(agentHealths);
        }

        @Override
        @Transient
        public final Builder agentHealthsWithStrings(Collection<String> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copy(agentHealths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealthsWithStrings(String... agentHealths) {
            agentHealthsWithStrings(Arrays.asList(agentHealths));
            return this;
        }

        @Override
        @Transient
        public final Builder agentHealths(Collection<AgentHealth> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copyEnumToString(agentHealths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealths(AgentHealth... agentHealths) {
            agentHealths(Arrays.asList(agentHealths));
            return this;
        }

        public final Collection<String> getAgentHealthCodes() {
            if (agentHealthCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return agentHealthCodes;
        }

        public final void setAgentHealthCodes(Collection<String> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copy(agentHealthCodes);
        }

        @Override
        @Transient
        public final Builder agentHealthCodesWithStrings(Collection<String> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copy(agentHealthCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealthCodesWithStrings(String... agentHealthCodes) {
            agentHealthCodesWithStrings(Arrays.asList(agentHealthCodes));
            return this;
        }

        @Override
        @Transient
        public final Builder agentHealthCodes(Collection<AgentHealthCode> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copyEnumToString(agentHealthCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentHealthCodes(AgentHealthCode... agentHealthCodes) {
            agentHealthCodes(Arrays.asList(agentHealthCodes));
            return this;
        }

        @Override
        public AgentFilter build() {
            return new AgentFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
