/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.BatchDescribeArnListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssessmentRunsRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, DescribeAssessmentRunsRequest> {
    private static final SdkField<List<String>> ASSESSMENT_RUN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentRunArns").getter(DescribeAssessmentRunsRequest.getter(DescribeAssessmentRunsRequest::assessmentRunArns)).setter(DescribeAssessmentRunsRequest.setter(Builder::assessmentRunArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARNS_FIELD));
    private final List<String> assessmentRunArns;

    private DescribeAssessmentRunsRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArns = builder.assessmentRunArns;
    }

    public final boolean hasAssessmentRunArns() {
        return this.assessmentRunArns != null && !(this.assessmentRunArns instanceof SdkAutoConstructList);
    }

    public final List<String> assessmentRunArns() {
        return this.assessmentRunArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentRunArns() ? this.assessmentRunArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentRunsRequest)) {
            return false;
        }
        DescribeAssessmentRunsRequest other = (DescribeAssessmentRunsRequest)((Object)obj);
        return this.hasAssessmentRunArns() == other.hasAssessmentRunArns() && Objects.equals(this.assessmentRunArns(), other.assessmentRunArns());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssessmentRunsRequest").add("AssessmentRunArns", this.hasAssessmentRunArns() ? this.assessmentRunArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentRunArns": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentRunsRequest, T> g) {
        return obj -> g.apply((DescribeAssessmentRunsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private List<String> assessmentRunArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentRunsRequest model) {
            super(model);
            this.assessmentRunArns(model.assessmentRunArns);
        }

        public final Collection<String> getAssessmentRunArns() {
            if (this.assessmentRunArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentRunArns;
        }

        public final void setAssessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = BatchDescribeArnListCopier.copy(assessmentRunArns);
        }

        @Override
        public final Builder assessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = BatchDescribeArnListCopier.copy(assessmentRunArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunArns(String ... assessmentRunArns) {
            this.assessmentRunArns(Arrays.asList(assessmentRunArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssessmentRunsRequest build() {
            return new DescribeAssessmentRunsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssessmentRunsRequest> {
        public Builder assessmentRunArns(Collection<String> var1);

        public Builder assessmentRunArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

