/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryMetadata> {
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageType").getter(TelemetryMetadata.getter(TelemetryMetadata::messageType)).setter(TelemetryMetadata.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageType").build()}).build();
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("count").getter(TelemetryMetadata.getter(TelemetryMetadata::count)).setter(TelemetryMetadata.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Long> DATA_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("dataSize").getter(TelemetryMetadata.getter(TelemetryMetadata::dataSize)).setter(TelemetryMetadata.setter(Builder::dataSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TYPE_FIELD, COUNT_FIELD, DATA_SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageType;
    private final Long count;
    private final Long dataSize;

    private TelemetryMetadata(BuilderImpl builder) {
        this.messageType = builder.messageType;
        this.count = builder.count;
        this.dataSize = builder.dataSize;
    }

    public final String messageType() {
        return this.messageType;
    }

    public final Long count() {
        return this.count;
    }

    public final Long dataSize() {
        return this.dataSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryMetadata)) {
            return false;
        }
        TelemetryMetadata other = (TelemetryMetadata)obj;
        return Objects.equals(this.messageType(), other.messageType()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.dataSize(), other.dataSize());
    }

    public final String toString() {
        return ToString.builder((String)"TelemetryMetadata").add("MessageType", (Object)this.messageType()).add("Count", (Object)this.count()).add("DataSize", (Object)this.dataSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageType": {
                return Optional.ofNullable(clazz.cast(this.messageType()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "dataSize": {
                return Optional.ofNullable(clazz.cast(this.dataSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TelemetryMetadata, T> g) {
        return obj -> g.apply((TelemetryMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageType;
        private Long count;
        private Long dataSize;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryMetadata model) {
            this.messageType(model.messageType);
            this.count(model.count);
            this.dataSize(model.dataSize);
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Long getDataSize() {
            return this.dataSize;
        }

        public final void setDataSize(Long dataSize) {
            this.dataSize = dataSize;
        }

        @Override
        public final Builder dataSize(Long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public TelemetryMetadata build() {
            return new TelemetryMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryMetadata> {
        public Builder messageType(String var1);

        public Builder count(Long var1);

        public Builder dataSize(Long var1);
    }
}

