/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse;

public class ListAssessmentRunAgentsIterable
implements SdkIterable<ListAssessmentRunAgentsResponse> {
    private final InspectorClient client;
    private final ListAssessmentRunAgentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssessmentRunAgentsIterable(InspectorClient client, ListAssessmentRunAgentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssessmentRunAgentsResponseFetcher();
    }

    public Iterator<ListAssessmentRunAgentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssessmentRunAgentsResponseFetcher
    implements SyncPageFetcher<ListAssessmentRunAgentsResponse> {
        private ListAssessmentRunAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentRunAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssessmentRunAgentsResponse nextPage(ListAssessmentRunAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentRunAgentsIterable.this.client.listAssessmentRunAgents(ListAssessmentRunAgentsIterable.this.firstRequest);
            }
            return ListAssessmentRunAgentsIterable.this.client.listAssessmentRunAgents((ListAssessmentRunAgentsRequest)((Object)ListAssessmentRunAgentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

