/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector.model.ListFindingsResponse;

public class ListFindingsIterable
implements SdkIterable<ListFindingsResponse> {
    private final InspectorClient client;
    private final ListFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFindingsIterable(InspectorClient client, ListFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFindingsResponseFetcher();
    }

    public Iterator<ListFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFindingsResponseFetcher
    implements SyncPageFetcher<ListFindingsResponse> {
        private ListFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFindingsResponse nextPage(ListFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsIterable.this.client.listFindings(ListFindingsIterable.this.firstRequest);
            }
            return ListFindingsIterable.this.client.listFindings((ListFindingsRequest)((Object)ListFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

