/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.ResourceGroupTag;
import software.amazon.awssdk.services.inspector.model.ResourceGroupTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceGroup> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ResourceGroup.getter(ResourceGroup::arn)).setter(ResourceGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<ResourceGroupTag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ResourceGroup.getter(ResourceGroup::tags)).setter(ResourceGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceGroupTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ResourceGroup.getter(ResourceGroup::createdAt)).setter(ResourceGroup.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TAGS_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<ResourceGroupTag> tags;
    private final Instant createdAt;

    private ResourceGroup(BuilderImpl builder) {
        this.arn = builder.arn;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<ResourceGroupTag> tags() {
        return this.tags;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceGroup)) {
            return false;
        }
        ResourceGroup other = (ResourceGroup)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceGroup").add("Arn", (Object)this.arn()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceGroup, T> g) {
        return obj -> g.apply((ResourceGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<ResourceGroupTag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceGroup model) {
            this.arn(model.arn);
            this.tags(model.tags);
            this.createdAt(model.createdAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<ResourceGroupTag.Builder> getTags() {
            List<ResourceGroupTag.Builder> result = ResourceGroupTagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<ResourceGroupTag.BuilderImpl> tags) {
            this.tags = ResourceGroupTagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<ResourceGroupTag> tags) {
            this.tags = ResourceGroupTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(ResourceGroupTag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<ResourceGroupTag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (ResourceGroupTag)((ResourceGroupTag.Builder)ResourceGroupTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ResourceGroup build() {
            return new ResourceGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceGroup> {
        public Builder arn(String var1);

        public Builder tags(Collection<ResourceGroupTag> var1);

        public Builder tags(ResourceGroupTag ... var1);

        public Builder tags(Consumer<ResourceGroupTag.Builder> ... var1);

        public Builder createdAt(Instant var1);
    }
}

