/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.AssessmentRulesPackageArnListCopier;
import software.amazon.awssdk.services.inspector.model.AssessmentRunFindingCountsCopier;
import software.amazon.awssdk.services.inspector.model.AssessmentRunNotification;
import software.amazon.awssdk.services.inspector.model.AssessmentRunNotificationListCopier;
import software.amazon.awssdk.services.inspector.model.AssessmentRunState;
import software.amazon.awssdk.services.inspector.model.AssessmentRunStateChange;
import software.amazon.awssdk.services.inspector.model.AssessmentRunStateChangeListCopier;
import software.amazon.awssdk.services.inspector.model.Attribute;
import software.amazon.awssdk.services.inspector.model.Severity;
import software.amazon.awssdk.services.inspector.model.UserAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentRun> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(AssessmentRun.getter(AssessmentRun::arn)).setter(AssessmentRun.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssessmentRun.getter(AssessmentRun::name)).setter(AssessmentRun.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ASSESSMENT_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentTemplateArn").getter(AssessmentRun.getter(AssessmentRun::assessmentTemplateArn)).setter(AssessmentRun.setter(Builder::assessmentTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(AssessmentRun.getter(AssessmentRun::stateAsString)).setter(AssessmentRun.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("durationInSeconds").getter(AssessmentRun.getter(AssessmentRun::durationInSeconds)).setter(AssessmentRun.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()}).build();
    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rulesPackageArns").getter(AssessmentRun.getter(AssessmentRun::rulesPackageArns)).setter(AssessmentRun.setter(Builder::rulesPackageArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FOR_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAttributesForFindings").getter(AssessmentRun.getter(AssessmentRun::userAttributesForFindings)).setter(AssessmentRun.setter(Builder::userAttributesForFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributesForFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AssessmentRun.getter(AssessmentRun::createdAt)).setter(AssessmentRun.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(AssessmentRun.getter(AssessmentRun::startedAt)).setter(AssessmentRun.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(AssessmentRun.getter(AssessmentRun::completedAt)).setter(AssessmentRun.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<Instant> STATE_CHANGED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stateChangedAt").getter(AssessmentRun.getter(AssessmentRun::stateChangedAt)).setter(AssessmentRun.setter(Builder::stateChangedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangedAt").build()}).build();
    private static final SdkField<Boolean> DATA_COLLECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dataCollected").getter(AssessmentRun.getter(AssessmentRun::dataCollected)).setter(AssessmentRun.setter(Builder::dataCollected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollected").build()}).build();
    private static final SdkField<List<AssessmentRunStateChange>> STATE_CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateChanges").getter(AssessmentRun.getter(AssessmentRun::stateChanges)).setter(AssessmentRun.setter(Builder::stateChanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentRunStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssessmentRunNotification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notifications").getter(AssessmentRun.getter(AssessmentRun::notifications)).setter(AssessmentRun.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentRunNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> FINDING_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("findingCounts").getter(AssessmentRun.getter(AssessmentRun::findingCountsAsStrings)).setter(AssessmentRun.setter(Builder::findingCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ASSESSMENT_TEMPLATE_ARN_FIELD, STATE_FIELD, DURATION_IN_SECONDS_FIELD, RULES_PACKAGE_ARNS_FIELD, USER_ATTRIBUTES_FOR_FINDINGS_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, COMPLETED_AT_FIELD, STATE_CHANGED_AT_FIELD, DATA_COLLECTED_FIELD, STATE_CHANGES_FIELD, NOTIFICATIONS_FIELD, FINDING_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("assessmentTemplateArn", ASSESSMENT_TEMPLATE_ARN_FIELD);
            this.put("state", STATE_FIELD);
            this.put("durationInSeconds", DURATION_IN_SECONDS_FIELD);
            this.put("rulesPackageArns", RULES_PACKAGE_ARNS_FIELD);
            this.put("userAttributesForFindings", USER_ATTRIBUTES_FOR_FINDINGS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("completedAt", COMPLETED_AT_FIELD);
            this.put("stateChangedAt", STATE_CHANGED_AT_FIELD);
            this.put("dataCollected", DATA_COLLECTED_FIELD);
            this.put("stateChanges", STATE_CHANGES_FIELD);
            this.put("notifications", NOTIFICATIONS_FIELD);
            this.put("findingCounts", FINDING_COUNTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String assessmentTemplateArn;
    private final String state;
    private final Integer durationInSeconds;
    private final List<String> rulesPackageArns;
    private final List<Attribute> userAttributesForFindings;
    private final Instant createdAt;
    private final Instant startedAt;
    private final Instant completedAt;
    private final Instant stateChangedAt;
    private final Boolean dataCollected;
    private final List<AssessmentRunStateChange> stateChanges;
    private final List<AssessmentRunNotification> notifications;
    private final Map<String, Integer> findingCounts;

    private AssessmentRun(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.assessmentTemplateArn = builder.assessmentTemplateArn;
        this.state = builder.state;
        this.durationInSeconds = builder.durationInSeconds;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.userAttributesForFindings = builder.userAttributesForFindings;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.stateChangedAt = builder.stateChangedAt;
        this.dataCollected = builder.dataCollected;
        this.stateChanges = builder.stateChanges;
        this.notifications = builder.notifications;
        this.findingCounts = builder.findingCounts;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String assessmentTemplateArn() {
        return this.assessmentTemplateArn;
    }

    public final AssessmentRunState state() {
        return AssessmentRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public final boolean hasRulesPackageArns() {
        return this.rulesPackageArns != null && !(this.rulesPackageArns instanceof SdkAutoConstructList);
    }

    public final List<String> rulesPackageArns() {
        return this.rulesPackageArns;
    }

    public final boolean hasUserAttributesForFindings() {
        return this.userAttributesForFindings != null && !(this.userAttributesForFindings instanceof SdkAutoConstructList);
    }

    public final List<Attribute> userAttributesForFindings() {
        return this.userAttributesForFindings;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final Instant stateChangedAt() {
        return this.stateChangedAt;
    }

    public final Boolean dataCollected() {
        return this.dataCollected;
    }

    public final boolean hasStateChanges() {
        return this.stateChanges != null && !(this.stateChanges instanceof SdkAutoConstructList);
    }

    public final List<AssessmentRunStateChange> stateChanges() {
        return this.stateChanges;
    }

    public final boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public final List<AssessmentRunNotification> notifications() {
        return this.notifications;
    }

    public final Map<Severity, Integer> findingCounts() {
        return AssessmentRunFindingCountsCopier.copyStringToEnum(this.findingCounts);
    }

    public final boolean hasFindingCounts() {
        return this.findingCounts != null && !(this.findingCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> findingCountsAsStrings() {
        return this.findingCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesPackageArns() ? this.rulesPackageArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAttributesForFindings() ? this.userAttributesForFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCollected());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateChanges() ? this.stateChanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingCounts() ? this.findingCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRun)) {
            return false;
        }
        AssessmentRun other = (AssessmentRun)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.assessmentTemplateArn(), other.assessmentTemplateArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && this.hasRulesPackageArns() == other.hasRulesPackageArns() && Objects.equals(this.rulesPackageArns(), other.rulesPackageArns()) && this.hasUserAttributesForFindings() == other.hasUserAttributesForFindings() && Objects.equals(this.userAttributesForFindings(), other.userAttributesForFindings()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.stateChangedAt(), other.stateChangedAt()) && Objects.equals(this.dataCollected(), other.dataCollected()) && this.hasStateChanges() == other.hasStateChanges() && Objects.equals(this.stateChanges(), other.stateChanges()) && this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && this.hasFindingCounts() == other.hasFindingCounts() && Objects.equals(this.findingCountsAsStrings(), other.findingCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentRun").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("AssessmentTemplateArn", (Object)this.assessmentTemplateArn()).add("State", (Object)this.stateAsString()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("RulesPackageArns", this.hasRulesPackageArns() ? this.rulesPackageArns() : null).add("UserAttributesForFindings", this.hasUserAttributesForFindings() ? this.userAttributesForFindings() : null).add("CreatedAt", (Object)this.createdAt()).add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).add("StateChangedAt", (Object)this.stateChangedAt()).add("DataCollected", (Object)this.dataCollected()).add("StateChanges", this.hasStateChanges() ? this.stateChanges() : null).add("Notifications", this.hasNotifications() ? this.notifications() : null).add("FindingCounts", this.hasFindingCounts() ? this.findingCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "assessmentTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentTemplateArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "durationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "rulesPackageArns": {
                return Optional.ofNullable(clazz.cast(this.rulesPackageArns()));
            }
            case "userAttributesForFindings": {
                return Optional.ofNullable(clazz.cast(this.userAttributesForFindings()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "stateChangedAt": {
                return Optional.ofNullable(clazz.cast(this.stateChangedAt()));
            }
            case "dataCollected": {
                return Optional.ofNullable(clazz.cast(this.dataCollected()));
            }
            case "stateChanges": {
                return Optional.ofNullable(clazz.cast(this.stateChanges()));
            }
            case "notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "findingCounts": {
                return Optional.ofNullable(clazz.cast(this.findingCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRun, T> g) {
        return obj -> g.apply((AssessmentRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String assessmentTemplateArn;
        private String state;
        private Integer durationInSeconds;
        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();
        private List<Attribute> userAttributesForFindings = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant startedAt;
        private Instant completedAt;
        private Instant stateChangedAt;
        private Boolean dataCollected;
        private List<AssessmentRunStateChange> stateChanges = DefaultSdkAutoConstructList.getInstance();
        private List<AssessmentRunNotification> notifications = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Integer> findingCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRun model) {
            this.arn(model.arn);
            this.name(model.name);
            this.assessmentTemplateArn(model.assessmentTemplateArn);
            this.state(model.state);
            this.durationInSeconds(model.durationInSeconds);
            this.rulesPackageArns(model.rulesPackageArns);
            this.userAttributesForFindings(model.userAttributesForFindings);
            this.createdAt(model.createdAt);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
            this.stateChangedAt(model.stateChangedAt);
            this.dataCollected(model.dataCollected);
            this.stateChanges(model.stateChanges);
            this.notifications(model.notifications);
            this.findingCountsWithStrings(model.findingCounts);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAssessmentTemplateArn() {
            return this.assessmentTemplateArn;
        }

        public final void setAssessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
        }

        @Override
        public final Builder assessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AssessmentRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final Collection<String> getRulesPackageArns() {
            if (this.rulesPackageArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rulesPackageArns;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String ... rulesPackageArns) {
            this.rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final List<Attribute.Builder> getUserAttributesForFindings() {
            List<Attribute.Builder> result = UserAttributeListCopier.copyToBuilder(this.userAttributesForFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAttributesForFindings(Collection<Attribute.BuilderImpl> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copyFromBuilder(userAttributesForFindings);
        }

        @Override
        public final Builder userAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copy(userAttributesForFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Attribute ... userAttributesForFindings) {
            this.userAttributesForFindings(Arrays.asList(userAttributesForFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Consumer<Attribute.Builder> ... userAttributesForFindings) {
            this.userAttributesForFindings(Stream.of(userAttributesForFindings).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getStateChangedAt() {
            return this.stateChangedAt;
        }

        public final void setStateChangedAt(Instant stateChangedAt) {
            this.stateChangedAt = stateChangedAt;
        }

        @Override
        public final Builder stateChangedAt(Instant stateChangedAt) {
            this.stateChangedAt = stateChangedAt;
            return this;
        }

        public final Boolean getDataCollected() {
            return this.dataCollected;
        }

        public final void setDataCollected(Boolean dataCollected) {
            this.dataCollected = dataCollected;
        }

        @Override
        public final Builder dataCollected(Boolean dataCollected) {
            this.dataCollected = dataCollected;
            return this;
        }

        public final List<AssessmentRunStateChange.Builder> getStateChanges() {
            List<AssessmentRunStateChange.Builder> result = AssessmentRunStateChangeListCopier.copyToBuilder(this.stateChanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateChanges(Collection<AssessmentRunStateChange.BuilderImpl> stateChanges) {
            this.stateChanges = AssessmentRunStateChangeListCopier.copyFromBuilder(stateChanges);
        }

        @Override
        public final Builder stateChanges(Collection<AssessmentRunStateChange> stateChanges) {
            this.stateChanges = AssessmentRunStateChangeListCopier.copy(stateChanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateChanges(AssessmentRunStateChange ... stateChanges) {
            this.stateChanges(Arrays.asList(stateChanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateChanges(Consumer<AssessmentRunStateChange.Builder> ... stateChanges) {
            this.stateChanges(Stream.of(stateChanges).map(c -> (AssessmentRunStateChange)((AssessmentRunStateChange.Builder)AssessmentRunStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssessmentRunNotification.Builder> getNotifications() {
            List<AssessmentRunNotification.Builder> result = AssessmentRunNotificationListCopier.copyToBuilder(this.notifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotifications(Collection<AssessmentRunNotification.BuilderImpl> notifications) {
            this.notifications = AssessmentRunNotificationListCopier.copyFromBuilder(notifications);
        }

        @Override
        public final Builder notifications(Collection<AssessmentRunNotification> notifications) {
            this.notifications = AssessmentRunNotificationListCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(AssessmentRunNotification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<AssessmentRunNotification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (AssessmentRunNotification)((AssessmentRunNotification.Builder)AssessmentRunNotification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getFindingCounts() {
            if (this.findingCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.findingCounts;
        }

        public final void setFindingCounts(Map<String, Integer> findingCounts) {
            this.findingCounts = AssessmentRunFindingCountsCopier.copy(findingCounts);
        }

        @Override
        public final Builder findingCountsWithStrings(Map<String, Integer> findingCounts) {
            this.findingCounts = AssessmentRunFindingCountsCopier.copy(findingCounts);
            return this;
        }

        @Override
        public final Builder findingCounts(Map<Severity, Integer> findingCounts) {
            this.findingCounts = AssessmentRunFindingCountsCopier.copyEnumToString(findingCounts);
            return this;
        }

        public AssessmentRun build() {
            return new AssessmentRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentRun> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder assessmentTemplateArn(String var1);

        public Builder state(String var1);

        public Builder state(AssessmentRunState var1);

        public Builder durationInSeconds(Integer var1);

        public Builder rulesPackageArns(Collection<String> var1);

        public Builder rulesPackageArns(String ... var1);

        public Builder userAttributesForFindings(Collection<Attribute> var1);

        public Builder userAttributesForFindings(Attribute ... var1);

        public Builder userAttributesForFindings(Consumer<Attribute.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder stateChangedAt(Instant var1);

        public Builder dataCollected(Boolean var1);

        public Builder stateChanges(Collection<AssessmentRunStateChange> var1);

        public Builder stateChanges(AssessmentRunStateChange ... var1);

        public Builder stateChanges(Consumer<AssessmentRunStateChange.Builder> ... var1);

        public Builder notifications(Collection<AssessmentRunNotification> var1);

        public Builder notifications(AssessmentRunNotification ... var1);

        public Builder notifications(Consumer<AssessmentRunNotification.Builder> ... var1);

        public Builder findingCountsWithStrings(Map<String, Integer> var1);

        public Builder findingCounts(Map<Severity, Integer> var1);
    }
}

