/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.ListReturnedArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentTargetsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, ListAssessmentTargetsResponse> {
    private static final SdkField<List<String>> ASSESSMENT_TARGET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentTargetArns").getter(ListAssessmentTargetsResponse.getter(ListAssessmentTargetsResponse::assessmentTargetArns)).setter(ListAssessmentTargetsResponse.setter(Builder::assessmentTargetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentTargetsResponse.getter(ListAssessmentTargetsResponse::nextToken)).setter(ListAssessmentTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assessmentTargetArns", ASSESSMENT_TARGET_ARNS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> assessmentTargetArns;
    private final String nextToken;

    private ListAssessmentTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArns = builder.assessmentTargetArns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessmentTargetArns() {
        return this.assessmentTargetArns != null && !(this.assessmentTargetArns instanceof SdkAutoConstructList);
    }

    public final List<String> assessmentTargetArns() {
        return this.assessmentTargetArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentTargetArns() ? this.assessmentTargetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentTargetsResponse)) {
            return false;
        }
        ListAssessmentTargetsResponse other = (ListAssessmentTargetsResponse)((Object)obj);
        return this.hasAssessmentTargetArns() == other.hasAssessmentTargetArns() && Objects.equals(this.assessmentTargetArns(), other.assessmentTargetArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssessmentTargetsResponse").add("AssessmentTargetArns", this.hasAssessmentTargetArns() ? this.assessmentTargetArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTargetArns": {
                return Optional.ofNullable(clazz.cast(this.assessmentTargetArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentTargetsResponse, T> g) {
        return obj -> g.apply((ListAssessmentTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<String> assessmentTargetArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentTargetsResponse model) {
            super(model);
            this.assessmentTargetArns(model.assessmentTargetArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAssessmentTargetArns() {
            if (this.assessmentTargetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentTargetArns;
        }

        public final void setAssessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = ListReturnedArnListCopier.copy(assessmentTargetArns);
        }

        @Override
        public final Builder assessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = ListReturnedArnListCopier.copy(assessmentTargetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargetArns(String ... assessmentTargetArns) {
            this.assessmentTargetArns(Arrays.asList(assessmentTargetArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentTargetsResponse build() {
            return new ListAssessmentTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentTargetsResponse> {
        public Builder assessmentTargetArns(Collection<String> var1);

        public Builder assessmentTargetArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

