/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used in the exception error that is thrown if you start an assessment run for an assessment target that includes an
 * EC2 instance that is already participating in another started assessment run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentAlreadyRunningAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentAlreadyRunningAssessment.Builder, AgentAlreadyRunningAssessment> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentAlreadyRunningAssessment::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentRunArn").getter(getter(AgentAlreadyRunningAssessment::assessmentRunArn))
            .setter(setter(Builder::assessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            ASSESSMENT_RUN_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String assessmentRunArn;

    private AgentAlreadyRunningAssessment(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.assessmentRunArn = builder.assessmentRunArn;
    }

    /**
     * <p>
     * ID of the agent that is running on an EC2 instance that is already participating in another started assessment
     * run.
     * </p>
     * 
     * @return ID of the agent that is running on an EC2 instance that is already participating in another started
     *         assessment run.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The ARN of the assessment run that has already been started.
     * </p>
     * 
     * @return The ARN of the assessment run that has already been started.
     */
    public final String assessmentRunArn() {
        return assessmentRunArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentAlreadyRunningAssessment)) {
            return false;
        }
        AgentAlreadyRunningAssessment other = (AgentAlreadyRunningAssessment) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(assessmentRunArn(), other.assessmentRunArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentAlreadyRunningAssessment").add("AgentId", agentId())
                .add("AssessmentRunArn", assessmentRunArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "assessmentRunArn":
            return Optional.ofNullable(clazz.cast(assessmentRunArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("assessmentRunArn", ASSESSMENT_RUN_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentAlreadyRunningAssessment, T> g) {
        return obj -> g.apply((AgentAlreadyRunningAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentAlreadyRunningAssessment> {
        /**
         * <p>
         * ID of the agent that is running on an EC2 instance that is already participating in another started
         * assessment run.
         * </p>
         * 
         * @param agentId
         *        ID of the agent that is running on an EC2 instance that is already participating in another started
         *        assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The ARN of the assessment run that has already been started.
         * </p>
         * 
         * @param assessmentRunArn
         *        The ARN of the assessment run that has already been started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArn(String assessmentRunArn);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String assessmentRunArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentAlreadyRunningAssessment model) {
            agentId(model.agentId);
            assessmentRunArn(model.assessmentRunArn);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAssessmentRunArn() {
            return assessmentRunArn;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        @Override
        public AgentAlreadyRunningAssessment build() {
            return new AgentAlreadyRunningAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
