/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used as one of the elements of the <a>AssessmentRun</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentRunStateChange implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentRunStateChange.Builder, AssessmentRunStateChange> {
    private static final SdkField<Instant> STATE_CHANGED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stateChangedAt").getter(getter(AssessmentRunStateChange::stateChangedAt))
            .setter(setter(Builder::stateChangedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangedAt").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(AssessmentRunStateChange::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_CHANGED_AT_FIELD,
            STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant stateChangedAt;

    private final String state;

    private AssessmentRunStateChange(BuilderImpl builder) {
        this.stateChangedAt = builder.stateChangedAt;
        this.state = builder.state;
    }

    /**
     * <p>
     * The last time the assessment run state changed.
     * </p>
     * 
     * @return The last time the assessment run state changed.
     */
    public final Instant stateChangedAt() {
        return stateChangedAt;
    }

    /**
     * <p>
     * The assessment run state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AssessmentRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The assessment run state.
     * @see AssessmentRunState
     */
    public final AssessmentRunState state() {
        return AssessmentRunState.fromValue(state);
    }

    /**
     * <p>
     * The assessment run state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AssessmentRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The assessment run state.
     * @see AssessmentRunState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunStateChange)) {
            return false;
        }
        AssessmentRunStateChange other = (AssessmentRunStateChange) obj;
        return Objects.equals(stateChangedAt(), other.stateChangedAt()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentRunStateChange").add("StateChangedAt", stateChangedAt()).add("State", stateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateChangedAt":
            return Optional.ofNullable(clazz.cast(stateChangedAt()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateChangedAt", STATE_CHANGED_AT_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunStateChange, T> g) {
        return obj -> g.apply((AssessmentRunStateChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentRunStateChange> {
        /**
         * <p>
         * The last time the assessment run state changed.
         * </p>
         * 
         * @param stateChangedAt
         *        The last time the assessment run state changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangedAt(Instant stateChangedAt);

        /**
         * <p>
         * The assessment run state.
         * </p>
         * 
         * @param state
         *        The assessment run state.
         * @see AssessmentRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentRunState
         */
        Builder state(String state);

        /**
         * <p>
         * The assessment run state.
         * </p>
         * 
         * @param state
         *        The assessment run state.
         * @see AssessmentRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentRunState
         */
        Builder state(AssessmentRunState state);
    }

    static final class BuilderImpl implements Builder {
        private Instant stateChangedAt;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunStateChange model) {
            stateChangedAt(model.stateChangedAt);
            state(model.state);
        }

        public final Instant getStateChangedAt() {
            return stateChangedAt;
        }

        public final void setStateChangedAt(Instant stateChangedAt) {
            this.stateChangedAt = stateChangedAt;
        }

        @Override
        public final Builder stateChangedAt(Instant stateChangedAt) {
            this.stateChangedAt = stateChangedAt;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AssessmentRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public AssessmentRunStateChange build() {
            return new AssessmentRunStateChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
