/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentTargetRequest extends InspectorRequest implements
        ToCopyableBuilder<CreateAssessmentTargetRequest.Builder, CreateAssessmentTargetRequest> {
    private static final SdkField<String> ASSESSMENT_TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentTargetName").getter(getter(CreateAssessmentTargetRequest::assessmentTargetName))
            .setter(setter(Builder::assessmentTargetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetName").build())
            .build();

    private static final SdkField<String> RESOURCE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGroupArn").getter(getter(CreateAssessmentTargetRequest::resourceGroupArn))
            .setter(setter(Builder::resourceGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_NAME_FIELD,
            RESOURCE_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assessmentTargetName;

    private final String resourceGroupArn;

    private CreateAssessmentTargetRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetName = builder.assessmentTargetName;
        this.resourceGroupArn = builder.resourceGroupArn;
    }

    /**
     * <p>
     * The user-defined name that identifies the assessment target that you want to create. The name must be unique
     * within the AWS account.
     * </p>
     * 
     * @return The user-defined name that identifies the assessment target that you want to create. The name must be
     *         unique within the AWS account.
     */
    public final String assessmentTargetName() {
        return assessmentTargetName;
    }

    /**
     * <p>
     * The ARN that specifies the resource group that is used to create the assessment target. If resourceGroupArn is
     * not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
     * </p>
     * 
     * @return The ARN that specifies the resource group that is used to create the assessment target. If
     *         resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included
     *         in the assessment target.
     */
    public final String resourceGroupArn() {
        return resourceGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTargetName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentTargetRequest)) {
            return false;
        }
        CreateAssessmentTargetRequest other = (CreateAssessmentTargetRequest) obj;
        return Objects.equals(assessmentTargetName(), other.assessmentTargetName())
                && Objects.equals(resourceGroupArn(), other.resourceGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssessmentTargetRequest").add("AssessmentTargetName", assessmentTargetName())
                .add("ResourceGroupArn", resourceGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargetName":
            return Optional.ofNullable(clazz.cast(assessmentTargetName()));
        case "resourceGroupArn":
            return Optional.ofNullable(clazz.cast(resourceGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assessmentTargetName", ASSESSMENT_TARGET_NAME_FIELD);
        map.put("resourceGroupArn", RESOURCE_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentTargetRequest, T> g) {
        return obj -> g.apply((CreateAssessmentTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssessmentTargetRequest> {
        /**
         * <p>
         * The user-defined name that identifies the assessment target that you want to create. The name must be unique
         * within the AWS account.
         * </p>
         * 
         * @param assessmentTargetName
         *        The user-defined name that identifies the assessment target that you want to create. The name must be
         *        unique within the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetName(String assessmentTargetName);

        /**
         * <p>
         * The ARN that specifies the resource group that is used to create the assessment target. If resourceGroupArn
         * is not specified, all EC2 instances in the current AWS account and region are included in the assessment
         * target.
         * </p>
         * 
         * @param resourceGroupArn
         *        The ARN that specifies the resource group that is used to create the assessment target. If
         *        resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are
         *        included in the assessment target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupArn(String resourceGroupArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String assessmentTargetName;

        private String resourceGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentTargetRequest model) {
            super(model);
            assessmentTargetName(model.assessmentTargetName);
            resourceGroupArn(model.resourceGroupArn);
        }

        public final String getAssessmentTargetName() {
            return assessmentTargetName;
        }

        public final void setAssessmentTargetName(String assessmentTargetName) {
            this.assessmentTargetName = assessmentTargetName;
        }

        @Override
        public final Builder assessmentTargetName(String assessmentTargetName) {
            this.assessmentTargetName = assessmentTargetName;
            return this;
        }

        public final String getResourceGroupArn() {
            return resourceGroupArn;
        }

        public final void setResourceGroupArn(String resourceGroupArn) {
            this.resourceGroupArn = resourceGroupArn;
        }

        @Override
        public final Builder resourceGroupArn(String resourceGroupArn) {
            this.resourceGroupArn = resourceGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentTargetRequest build() {
            return new CreateAssessmentTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
