/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCrossAccountAccessRoleResponse extends InspectorResponse implements
        ToCopyableBuilder<DescribeCrossAccountAccessRoleResponse.Builder, DescribeCrossAccountAccessRoleResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribeCrossAccountAccessRoleResponse::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Boolean> VALID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("valid")
            .getter(getter(DescribeCrossAccountAccessRoleResponse::valid)).setter(setter(Builder::valid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valid").build()).build();

    private static final SdkField<Instant> REGISTERED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("registeredAt").getter(getter(DescribeCrossAccountAccessRoleResponse::registeredAt))
            .setter(setter(Builder::registeredAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, VALID_FIELD,
            REGISTERED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String roleArn;

    private final Boolean valid;

    private final Instant registeredAt;

    private DescribeCrossAccountAccessRoleResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.valid = builder.valid;
        this.registeredAt = builder.registeredAt;
    }

    /**
     * <p>
     * The ARN that specifies the IAM role that Amazon Inspector uses to access your AWS account.
     * </p>
     * 
     * @return The ARN that specifies the IAM role that Amazon Inspector uses to access your AWS account.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the IAM role has the necessary policies attached to enable Amazon
     * Inspector to access your AWS account.
     * </p>
     * 
     * @return A Boolean value that specifies whether the IAM role has the necessary policies attached to enable Amazon
     *         Inspector to access your AWS account.
     */
    public final Boolean valid() {
        return valid;
    }

    /**
     * <p>
     * The date when the cross-account access role was registered.
     * </p>
     * 
     * @return The date when the cross-account access role was registered.
     */
    public final Instant registeredAt() {
        return registeredAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(valid());
        hashCode = 31 * hashCode + Objects.hashCode(registeredAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCrossAccountAccessRoleResponse)) {
            return false;
        }
        DescribeCrossAccountAccessRoleResponse other = (DescribeCrossAccountAccessRoleResponse) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(valid(), other.valid())
                && Objects.equals(registeredAt(), other.registeredAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCrossAccountAccessRoleResponse").add("RoleArn", roleArn()).add("Valid", valid())
                .add("RegisteredAt", registeredAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "valid":
            return Optional.ofNullable(clazz.cast(valid()));
        case "registeredAt":
            return Optional.ofNullable(clazz.cast(registeredAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("valid", VALID_FIELD);
        map.put("registeredAt", REGISTERED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCrossAccountAccessRoleResponse, T> g) {
        return obj -> g.apply((DescribeCrossAccountAccessRoleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCrossAccountAccessRoleResponse> {
        /**
         * <p>
         * The ARN that specifies the IAM role that Amazon Inspector uses to access your AWS account.
         * </p>
         * 
         * @param roleArn
         *        The ARN that specifies the IAM role that Amazon Inspector uses to access your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A Boolean value that specifies whether the IAM role has the necessary policies attached to enable Amazon
         * Inspector to access your AWS account.
         * </p>
         * 
         * @param valid
         *        A Boolean value that specifies whether the IAM role has the necessary policies attached to enable
         *        Amazon Inspector to access your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valid(Boolean valid);

        /**
         * <p>
         * The date when the cross-account access role was registered.
         * </p>
         * 
         * @param registeredAt
         *        The date when the cross-account access role was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredAt(Instant registeredAt);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private String roleArn;

        private Boolean valid;

        private Instant registeredAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCrossAccountAccessRoleResponse model) {
            super(model);
            roleArn(model.roleArn);
            valid(model.valid);
            registeredAt(model.registeredAt);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getValid() {
            return valid;
        }

        public final void setValid(Boolean valid) {
            this.valid = valid;
        }

        @Override
        public final Builder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        public final Instant getRegisteredAt() {
            return registeredAt;
        }

        public final void setRegisteredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public final Builder registeredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        @Override
        public DescribeCrossAccountAccessRoleResponse build() {
            return new DescribeCrossAccountAccessRoleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
