/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <a>ListEventSubscriptions</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(Subscription::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("topicArn").getter(getter(Subscription::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicArn").build()).build();

    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_FIELD = SdkField
            .<List<EventSubscription>> builder(MarshallingType.LIST)
            .memberName("eventSubscriptions")
            .getter(getter(Subscription::eventSubscriptions))
            .setter(setter(Builder::eventSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TOPIC_ARN_FIELD, EVENT_SUBSCRIPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String topicArn;

    private final List<EventSubscription> eventSubscriptions;

    private Subscription(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.topicArn = builder.topicArn;
        this.eventSubscriptions = builder.eventSubscriptions;
    }

    /**
     * <p>
     * The ARN of the assessment template that is used during the event for which the SNS notification is sent.
     * </p>
     * 
     * @return The ARN of the assessment template that is used during the event for which the SNS notification is sent.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
     * </p>
     * 
     * @return The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSubscriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSubscriptions() {
        return eventSubscriptions != null && !(eventSubscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of existing event subscriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSubscriptions} method.
     * </p>
     * 
     * @return The list of existing event subscriptions.
     */
    public final List<EventSubscription> eventSubscriptions() {
        return eventSubscriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSubscriptions() ? eventSubscriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(topicArn(), other.topicArn())
                && hasEventSubscriptions() == other.hasEventSubscriptions()
                && Objects.equals(eventSubscriptions(), other.eventSubscriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Subscription").add("ResourceArn", resourceArn()).add("TopicArn", topicArn())
                .add("EventSubscriptions", hasEventSubscriptions() ? eventSubscriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "topicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "eventSubscriptions":
            return Optional.ofNullable(clazz.cast(eventSubscriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("topicArn", TOPIC_ARN_FIELD);
        map.put("eventSubscriptions", EVENT_SUBSCRIPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The ARN of the assessment template that is used during the event for which the SNS notification is sent.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the assessment template that is used during the event for which the SNS notification is
         *        sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The list of existing event subscriptions.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of existing event subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions);

        /**
         * <p>
         * The list of existing event subscriptions.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of existing event subscriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(EventSubscription... eventSubscriptions);

        /**
         * <p>
         * The list of existing event subscriptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector.model.EventSubscription.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector.model.EventSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector.model.EventSubscription.Builder#build()} is called
         * immediately and its result is passed to {@link #eventSubscriptions(List<EventSubscription>)}.
         * 
         * @param eventSubscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector.model.EventSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSubscriptions(java.util.Collection<EventSubscription>)
         */
        Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String topicArn;

        private List<EventSubscription> eventSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            resourceArn(model.resourceArn);
            topicArn(model.topicArn);
            eventSubscriptions(model.eventSubscriptions);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptions() {
            List<EventSubscription.Builder> result = EventSubscriptionListCopier.copyToBuilder(this.eventSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptions(Collection<EventSubscription.BuilderImpl> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copyFromBuilder(eventSubscriptions);
        }

        @Override
        public final Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copy(eventSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(EventSubscription... eventSubscriptions) {
            eventSubscriptions(Arrays.asList(eventSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions) {
            eventSubscriptions(Stream.of(eventSubscriptions).map(c -> EventSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
