/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorException;
import software.amazon.awssdk.services.inspector.model.InvalidInputErrorCode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidInputException
extends InspectorException
implements ToCopyableBuilder<Builder, InvalidInputException> {
    private static final SdkField<Boolean> CAN_RETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("canRetry").getter(InvalidInputException.getter(InvalidInputException::canRetry)).setter(InvalidInputException.setter(Builder::canRetry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canRetry").build()}).build();
    private static final SdkField<String> INSPECTOR_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inspectorErrorCode").getter(InvalidInputException.getter(InvalidInputException::inspectorErrorCodeAsString)).setter(InvalidInputException.setter(Builder::inspectorErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_RETRY_FIELD, INSPECTOR_ERROR_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvalidInputException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean canRetry;
    private final String inspectorErrorCode;

    private InvalidInputException(BuilderImpl builder) {
        super(builder);
        this.canRetry = builder.canRetry;
        this.inspectorErrorCode = builder.inspectorErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public Boolean canRetry() {
        return this.canRetry;
    }

    public InvalidInputErrorCode inspectorErrorCode() {
        return InvalidInputErrorCode.fromValue(this.inspectorErrorCode);
    }

    public String inspectorErrorCodeAsString() {
        return this.inspectorErrorCode;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("canRetry", CAN_RETRY_FIELD);
        map.put("errorCode", INSPECTOR_ERROR_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidInputException, T> g) {
        return obj -> g.apply((InvalidInputException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorException.BuilderImpl
    implements Builder {
        private Boolean canRetry;
        private String inspectorErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidInputException model) {
            super(model);
            this.canRetry(model.canRetry);
            this.inspectorErrorCode(model.inspectorErrorCode);
        }

        public final Boolean getCanRetry() {
            return this.canRetry;
        }

        public final void setCanRetry(Boolean canRetry) {
            this.canRetry = canRetry;
        }

        @Override
        public final Builder canRetry(Boolean canRetry) {
            this.canRetry = canRetry;
            return this;
        }

        public final String getInspectorErrorCode() {
            return this.inspectorErrorCode;
        }

        public final void setInspectorErrorCode(String inspectorErrorCode) {
            this.inspectorErrorCode = inspectorErrorCode;
        }

        @Override
        public final Builder inspectorErrorCode(String inspectorErrorCode) {
            this.inspectorErrorCode = inspectorErrorCode;
            return this;
        }

        @Override
        public final Builder inspectorErrorCode(InvalidInputErrorCode inspectorErrorCode) {
            this.inspectorErrorCode(inspectorErrorCode == null ? null : inspectorErrorCode.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public InvalidInputException build() {
            return new InvalidInputException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidInputException>,
    InspectorException.Builder {
        public Builder canRetry(Boolean var1);

        public Builder inspectorErrorCode(String var1);

        public Builder inspectorErrorCode(InvalidInputErrorCode var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

