/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.services.inspector.model.ListReturnedArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentTemplatesResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, ListAssessmentTemplatesResponse> {
    private static final SdkField<List<String>> ASSESSMENT_TEMPLATE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentTemplateArns").getter(ListAssessmentTemplatesResponse.getter(ListAssessmentTemplatesResponse::assessmentTemplateArns)).setter(ListAssessmentTemplatesResponse.setter(Builder::assessmentTemplateArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentTemplatesResponse.getter(ListAssessmentTemplatesResponse::nextToken)).setter(ListAssessmentTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TEMPLATE_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssessmentTemplatesResponse.memberNameToFieldInitializer();
    private final List<String> assessmentTemplateArns;
    private final String nextToken;

    private ListAssessmentTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplateArns = builder.assessmentTemplateArns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessmentTemplateArns() {
        return this.assessmentTemplateArns != null && !(this.assessmentTemplateArns instanceof SdkAutoConstructList);
    }

    public final List<String> assessmentTemplateArns() {
        return this.assessmentTemplateArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentTemplateArns() ? this.assessmentTemplateArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentTemplatesResponse)) {
            return false;
        }
        ListAssessmentTemplatesResponse other = (ListAssessmentTemplatesResponse)((Object)obj);
        return this.hasAssessmentTemplateArns() == other.hasAssessmentTemplateArns() && Objects.equals(this.assessmentTemplateArns(), other.assessmentTemplateArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssessmentTemplatesResponse").add("AssessmentTemplateArns", this.hasAssessmentTemplateArns() ? this.assessmentTemplateArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTemplateArns": {
                return Optional.ofNullable(clazz.cast(this.assessmentTemplateArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assessmentTemplateArns", ASSESSMENT_TEMPLATE_ARNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentTemplatesResponse, T> g) {
        return obj -> g.apply((ListAssessmentTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<String> assessmentTemplateArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentTemplatesResponse model) {
            super(model);
            this.assessmentTemplateArns(model.assessmentTemplateArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAssessmentTemplateArns() {
            if (this.assessmentTemplateArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentTemplateArns;
        }

        public final void setAssessmentTemplateArns(Collection<String> assessmentTemplateArns) {
            this.assessmentTemplateArns = ListReturnedArnListCopier.copy(assessmentTemplateArns);
        }

        @Override
        public final Builder assessmentTemplateArns(Collection<String> assessmentTemplateArns) {
            this.assessmentTemplateArns = ListReturnedArnListCopier.copy(assessmentTemplateArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTemplateArns(String ... assessmentTemplateArns) {
            this.assessmentTemplateArns(Arrays.asList(assessmentTemplateArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentTemplatesResponse build() {
            return new ListAssessmentTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentTemplatesResponse> {
        public Builder assessmentTemplateArns(Collection<String> var1);

        public Builder assessmentTemplateArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

