/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.Exclusion;
import software.amazon.awssdk.services.inspector.model.ExclusionMapCopier;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExclusionsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeExclusionsResponse> {
    private static final SdkField<Map<String, Exclusion>> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("exclusions").getter(DescribeExclusionsResponse.getter(DescribeExclusionsResponse::exclusions)).setter(DescribeExclusionsResponse.setter(Builder::exclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Exclusion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("failedItems").getter(DescribeExclusionsResponse.getter(DescribeExclusionsResponse::failedItems)).setter(DescribeExclusionsResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSIONS_FIELD, FAILED_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeExclusionsResponse.memberNameToFieldInitializer();
    private final Map<String, Exclusion> exclusions;
    private final Map<String, FailedItemDetails> failedItems;

    private DescribeExclusionsResponse(BuilderImpl builder) {
        super(builder);
        this.exclusions = builder.exclusions;
        this.failedItems = builder.failedItems;
    }

    public final boolean hasExclusions() {
        return this.exclusions != null && !(this.exclusions instanceof SdkAutoConstructMap);
    }

    public final Map<String, Exclusion> exclusions() {
        return this.exclusions;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusions() ? this.exclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExclusionsResponse)) {
            return false;
        }
        DescribeExclusionsResponse other = (DescribeExclusionsResponse)((Object)obj);
        return this.hasExclusions() == other.hasExclusions() && Objects.equals(this.exclusions(), other.exclusions()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExclusionsResponse").add("Exclusions", this.hasExclusions() ? this.exclusions() : null).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exclusions", EXCLUSIONS_FIELD);
        map.put("failedItems", FAILED_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExclusionsResponse, T> g) {
        return obj -> g.apply((DescribeExclusionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private Map<String, Exclusion> exclusions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExclusionsResponse model) {
            super(model);
            this.exclusions(model.exclusions);
            this.failedItems(model.failedItems);
        }

        public final Map<String, Exclusion.Builder> getExclusions() {
            Map<String, Exclusion.Builder> result = ExclusionMapCopier.copyToBuilder(this.exclusions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExclusions(Map<String, Exclusion.BuilderImpl> exclusions) {
            this.exclusions = ExclusionMapCopier.copyFromBuilder(exclusions);
        }

        @Override
        public final Builder exclusions(Map<String, Exclusion> exclusions) {
            this.exclusions = ExclusionMapCopier.copy(exclusions);
            return this;
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            Map<String, FailedItemDetails.Builder> result = FailedItemsCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        @Override
        public DescribeExclusionsResponse build() {
            return new DescribeExclusionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExclusionsResponse> {
        public Builder exclusions(Map<String, Exclusion> var1);

        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

