/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.InspectorServiceClientConfiguration;
import software.amazon.awssdk.services.inspector.internal.InspectorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.inspector.model.AccessDeniedException;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse;
import software.amazon.awssdk.services.inspector.model.AgentsAlreadyRunningAssessmentException;
import software.amazon.awssdk.services.inspector.model.AssessmentRunInProgressException;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse;
import software.amazon.awssdk.services.inspector.model.InspectorException;
import software.amazon.awssdk.services.inspector.model.InternalException;
import software.amazon.awssdk.services.inspector.model.InvalidCrossAccountRoleException;
import software.amazon.awssdk.services.inspector.model.InvalidInputException;
import software.amazon.awssdk.services.inspector.model.LimitExceededException;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse;
import software.amazon.awssdk.services.inspector.model.ListExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.ListExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.NoSuchEntityException;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse;
import software.amazon.awssdk.services.inspector.model.PreviewGenerationInProgressException;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse;
import software.amazon.awssdk.services.inspector.model.ServiceTemporarilyUnavailableException;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventRequest;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventResponse;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventResponse;
import software.amazon.awssdk.services.inspector.model.UnsupportedFeatureException;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.transform.AddAttributesToFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateAssessmentTargetRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateAssessmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateExclusionsPreviewRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.CreateResourceGroupRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DeleteAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DeleteAssessmentTargetRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DeleteAssessmentTemplateRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeAssessmentTargetsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeAssessmentTemplatesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeCrossAccountAccessRoleRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeExclusionsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeResourceGroupsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.DescribeRulesPackagesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.GetAssessmentReportRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.GetExclusionsPreviewRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.GetTelemetryMetadataRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentRunAgentsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentTargetsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListAssessmentTemplatesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListExclusionsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListRulesPackagesRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.PreviewAgentsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.RegisterCrossAccountAccessRoleRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.RemoveAttributesFromFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.SetTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.StartAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.StopAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.SubscribeToEventRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.UnsubscribeFromEventRequestMarshaller;
import software.amazon.awssdk.services.inspector.transform.UpdateAssessmentTargetRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultInspectorAsyncClient
implements InspectorAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultInspectorAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultInspectorAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Inspector#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddAttributesToFindingsResponse> addAttributesToFindings(AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addAttributesToFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, addAttributesToFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddAttributesToFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddAttributesToFindingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddAttributesToFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddAttributesToFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addAttributesToFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$addAttributesToFindings$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$addAttributesToFindings$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAssessmentTargetResponse> createAssessmentTarget(CreateAssessmentTargetRequest createAssessmentTargetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAssessmentTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, createAssessmentTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAssessmentTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAssessmentTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAssessmentTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAssessmentTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAssessmentTargetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$createAssessmentTarget$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$createAssessmentTarget$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAssessmentTemplateResponse> createAssessmentTemplate(CreateAssessmentTemplateRequest createAssessmentTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAssessmentTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, createAssessmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAssessmentTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAssessmentTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAssessmentTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAssessmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAssessmentTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$createAssessmentTemplate$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$createAssessmentTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateExclusionsPreviewResponse> createExclusionsPreview(CreateExclusionsPreviewRequest createExclusionsPreviewRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createExclusionsPreviewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, createExclusionsPreviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateExclusionsPreview");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateExclusionsPreviewResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateExclusionsPreview").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateExclusionsPreviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createExclusionsPreviewRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$createExclusionsPreview$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$createExclusionsPreview$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateResourceGroupResponse> createResourceGroup(CreateResourceGroupRequest createResourceGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createResourceGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, createResourceGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateResourceGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createResourceGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$createResourceGroup$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$createResourceGroup$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAssessmentRunResponse> deleteAssessmentRun(DeleteAssessmentRunRequest deleteAssessmentRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssessmentRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssessmentRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAssessmentRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$deleteAssessmentRun$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$deleteAssessmentRun$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAssessmentTargetResponse> deleteAssessmentTarget(DeleteAssessmentTargetRequest deleteAssessmentTargetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAssessmentTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAssessmentTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssessmentTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssessmentTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssessmentTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAssessmentTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAssessmentTargetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$deleteAssessmentTarget$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$deleteAssessmentTarget$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAssessmentTemplateResponse> deleteAssessmentTemplate(DeleteAssessmentTemplateRequest deleteAssessmentTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAssessmentTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAssessmentTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAssessmentTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAssessmentTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAssessmentTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAssessmentTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAssessmentTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$deleteAssessmentTemplate$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$deleteAssessmentTemplate$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAssessmentRunsResponse> describeAssessmentRuns(DescribeAssessmentRunsRequest describeAssessmentRunsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAssessmentRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeAssessmentRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAssessmentRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAssessmentRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAssessmentRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAssessmentRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAssessmentRunsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeAssessmentRuns$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeAssessmentRuns$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAssessmentTargetsResponse> describeAssessmentTargets(DescribeAssessmentTargetsRequest describeAssessmentTargetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAssessmentTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeAssessmentTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAssessmentTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAssessmentTargetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAssessmentTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAssessmentTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAssessmentTargetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeAssessmentTargets$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeAssessmentTargets$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAssessmentTemplatesResponse> describeAssessmentTemplates(DescribeAssessmentTemplatesRequest describeAssessmentTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAssessmentTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeAssessmentTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAssessmentTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAssessmentTemplatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAssessmentTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAssessmentTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAssessmentTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeAssessmentTemplates$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeAssessmentTemplates$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCrossAccountAccessRoleResponse> describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCrossAccountAccessRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeCrossAccountAccessRoleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCrossAccountAccessRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCrossAccountAccessRoleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCrossAccountAccessRole").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCrossAccountAccessRoleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCrossAccountAccessRoleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeCrossAccountAccessRole$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeCrossAccountAccessRole$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeExclusionsResponse> describeExclusions(DescribeExclusionsRequest describeExclusionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExclusionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeExclusionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExclusions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExclusionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExclusions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeExclusionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeExclusionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeExclusions$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeExclusions$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFindingsResponse> describeFindings(DescribeFindingsRequest describeFindingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFindingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeFindings$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeFindings$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourceGroupsResponse> describeResourceGroups(DescribeResourceGroupsRequest describeResourceGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourceGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeResourceGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourceGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourceGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeResourceGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResourceGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeResourceGroups$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeResourceGroups$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRulesPackagesResponse> describeRulesPackages(DescribeRulesPackagesRequest describeRulesPackagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRulesPackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, describeRulesPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRulesPackages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRulesPackagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRulesPackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRulesPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRulesPackagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$describeRulesPackages$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$describeRulesPackages$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAssessmentReportResponse> getAssessmentReport(GetAssessmentReportRequest getAssessmentReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAssessmentReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, getAssessmentReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssessmentReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssessmentReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssessmentReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAssessmentReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAssessmentReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$getAssessmentReport$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$getAssessmentReport$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetExclusionsPreviewResponse> getExclusionsPreview(GetExclusionsPreviewRequest getExclusionsPreviewRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getExclusionsPreviewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, getExclusionsPreviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExclusionsPreview");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExclusionsPreviewResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExclusionsPreview").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetExclusionsPreviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getExclusionsPreviewRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$getExclusionsPreview$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$getExclusionsPreview$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTelemetryMetadataResponse> getTelemetryMetadata(GetTelemetryMetadataRequest getTelemetryMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTelemetryMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, getTelemetryMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTelemetryMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTelemetryMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTelemetryMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTelemetryMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTelemetryMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$getTelemetryMetadata$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$getTelemetryMetadata$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAssessmentRunAgentsResponse> listAssessmentRunAgents(ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentRunAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listAssessmentRunAgentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentRunAgents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentRunAgentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentRunAgents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAssessmentRunAgentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAssessmentRunAgentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listAssessmentRunAgents$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listAssessmentRunAgents$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAssessmentRunsResponse> listAssessmentRuns(ListAssessmentRunsRequest listAssessmentRunsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listAssessmentRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentRuns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAssessmentRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAssessmentRunsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listAssessmentRuns$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listAssessmentRuns$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAssessmentTargetsResponse> listAssessmentTargets(ListAssessmentTargetsRequest listAssessmentTargetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listAssessmentTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentTargets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentTargetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAssessmentTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAssessmentTargetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listAssessmentTargets$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listAssessmentTargets$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAssessmentTemplatesResponse> listAssessmentTemplates(ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAssessmentTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listAssessmentTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssessmentTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssessmentTemplatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssessmentTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAssessmentTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAssessmentTemplatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listAssessmentTemplates$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listAssessmentTemplates$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEventSubscriptionsResponse> listEventSubscriptions(ListEventSubscriptionsRequest listEventSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listEventSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventSubscriptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEventSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEventSubscriptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listEventSubscriptions$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listEventSubscriptions$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListExclusionsResponse> listExclusions(ListExclusionsRequest listExclusionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listExclusionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listExclusionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExclusions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExclusionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExclusions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListExclusionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listExclusionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listExclusions$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listExclusions$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listFindings$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listFindings$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRulesPackagesResponse> listRulesPackages(ListRulesPackagesRequest listRulesPackagesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRulesPackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listRulesPackagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRulesPackages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesPackagesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRulesPackages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRulesPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRulesPackagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listRulesPackages$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listRulesPackages$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$listTagsForResource$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$listTagsForResource$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PreviewAgentsResponse> previewAgents(PreviewAgentsRequest previewAgentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)previewAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, previewAgentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PreviewAgents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PreviewAgentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PreviewAgents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PreviewAgentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)previewAgentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$previewAgents$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$previewAgents$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterCrossAccountAccessRoleResponse> registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerCrossAccountAccessRoleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, registerCrossAccountAccessRoleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterCrossAccountAccessRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterCrossAccountAccessRoleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterCrossAccountAccessRole").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterCrossAccountAccessRoleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerCrossAccountAccessRoleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$registerCrossAccountAccessRole$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$registerCrossAccountAccessRole$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveAttributesFromFindingsResponse> removeAttributesFromFindings(RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeAttributesFromFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, removeAttributesFromFindingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveAttributesFromFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAttributesFromFindingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAttributesFromFindings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveAttributesFromFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeAttributesFromFindingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$removeAttributesFromFindings$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$removeAttributesFromFindings$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetTagsForResourceResponse> setTagsForResource(SetTagsForResourceRequest setTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, setTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$setTagsForResource$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$setTagsForResource$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartAssessmentRunResponse> startAssessmentRun(StartAssessmentRunRequest startAssessmentRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, startAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAssessmentRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAssessmentRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startAssessmentRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$startAssessmentRun$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$startAssessmentRun$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopAssessmentRunResponse> stopAssessmentRun(StopAssessmentRunRequest stopAssessmentRunRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopAssessmentRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, stopAssessmentRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopAssessmentRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopAssessmentRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopAssessmentRun").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopAssessmentRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopAssessmentRunRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$stopAssessmentRun$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$stopAssessmentRun$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SubscribeToEventResponse> subscribeToEvent(SubscribeToEventRequest subscribeToEventRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)subscribeToEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, subscribeToEventRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubscribeToEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubscribeToEventResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubscribeToEvent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SubscribeToEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)subscribeToEventRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$subscribeToEvent$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$subscribeToEvent$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnsubscribeFromEventResponse> unsubscribeFromEvent(UnsubscribeFromEventRequest unsubscribeFromEventRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unsubscribeFromEventRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, unsubscribeFromEventRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnsubscribeFromEvent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnsubscribeFromEventResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnsubscribeFromEvent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UnsubscribeFromEventRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)unsubscribeFromEventRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$unsubscribeFromEvent$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$unsubscribeFromEvent$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAssessmentTargetResponse> updateAssessmentTarget(UpdateAssessmentTargetRequest updateAssessmentTargetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAssessmentTargetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultInspectorAsyncClient.resolveMetricPublishers(clientConfiguration, updateAssessmentTargetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Inspector");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAssessmentTarget");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAssessmentTargetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AssessmentRunInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AssessmentRunInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AssessmentRunInProgressException::builder).build());
                    }
                    case "UnsupportedFeatureException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedFeatureException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ServiceTemporarilyUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceTemporarilyUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceTemporarilyUnavailableException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "NoSuchEntityException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchEntityException::builder).build());
                    }
                    case "AgentsAlreadyRunningAssessmentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AgentsAlreadyRunningAssessmentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AgentsAlreadyRunningAssessmentException::builder).build());
                    }
                    case "PreviewGenerationInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreviewGenerationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PreviewGenerationInProgressException::builder).build());
                    }
                    case "InvalidCrossAccountRoleException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCrossAccountRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCrossAccountRoleException::builder).build());
                    }
                    case "InternalException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAssessmentTarget").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAssessmentTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAssessmentTargetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultInspectorAsyncClient.lambda$updateAssessmentTarget$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultInspectorAsyncClient.lambda$updateAssessmentTarget$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final InspectorServiceClientConfiguration serviceClientConfiguration() {
        return new InspectorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "inspector";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(InspectorException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        InspectorServiceClientConfigurationBuilder serviceConfigBuilder = new InspectorServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateAssessmentTarget$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAssessmentTarget$146(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAssessmentTargetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$unsubscribeFromEvent$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unsubscribeFromEvent$142(List metricPublishers, MetricCollector apiCallMetricCollector, UnsubscribeFromEventResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$subscribeToEvent$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$subscribeToEvent$138(List metricPublishers, MetricCollector apiCallMetricCollector, SubscribeToEventResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopAssessmentRun$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopAssessmentRun$134(List metricPublishers, MetricCollector apiCallMetricCollector, StopAssessmentRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startAssessmentRun$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAssessmentRun$130(List metricPublishers, MetricCollector apiCallMetricCollector, StartAssessmentRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setTagsForResource$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setTagsForResource$126(List metricPublishers, MetricCollector apiCallMetricCollector, SetTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeAttributesFromFindings$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeAttributesFromFindings$122(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveAttributesFromFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerCrossAccountAccessRole$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerCrossAccountAccessRole$118(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterCrossAccountAccessRoleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$previewAgents$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$previewAgents$114(List metricPublishers, MetricCollector apiCallMetricCollector, PreviewAgentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$110(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRulesPackages$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRulesPackages$106(List metricPublishers, MetricCollector apiCallMetricCollector, ListRulesPackagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFindings$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFindings$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listExclusions$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExclusions$98(List metricPublishers, MetricCollector apiCallMetricCollector, ListExclusionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEventSubscriptions$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventSubscriptions$94(List metricPublishers, MetricCollector apiCallMetricCollector, ListEventSubscriptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAssessmentTemplates$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentTemplates$90(List metricPublishers, MetricCollector apiCallMetricCollector, ListAssessmentTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAssessmentTargets$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentTargets$86(List metricPublishers, MetricCollector apiCallMetricCollector, ListAssessmentTargetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAssessmentRuns$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentRuns$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListAssessmentRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAssessmentRunAgents$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAssessmentRunAgents$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListAssessmentRunAgentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTelemetryMetadata$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTelemetryMetadata$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetTelemetryMetadataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getExclusionsPreview$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExclusionsPreview$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetExclusionsPreviewResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAssessmentReport$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssessmentReport$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetAssessmentReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRulesPackages$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRulesPackages$62(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRulesPackagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeResourceGroups$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourceGroups$58(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeResourceGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFindings$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFindings$54(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeExclusions$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExclusions$50(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeExclusionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCrossAccountAccessRole$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCrossAccountAccessRole$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCrossAccountAccessRoleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAssessmentTemplates$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAssessmentTemplates$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAssessmentTemplatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAssessmentTargets$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAssessmentTargets$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAssessmentTargetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAssessmentRuns$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAssessmentRuns$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAssessmentRunsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAssessmentTemplate$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssessmentTemplate$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAssessmentTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAssessmentTarget$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssessmentTarget$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAssessmentTargetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAssessmentRun$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAssessmentRun$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAssessmentRunResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createResourceGroup$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResourceGroup$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateResourceGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createExclusionsPreview$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createExclusionsPreview$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateExclusionsPreviewResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAssessmentTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAssessmentTemplate$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAssessmentTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAssessmentTarget$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAssessmentTarget$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAssessmentTargetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addAttributesToFindings$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addAttributesToFindings$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddAttributesToFindingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

